%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function res = Beta_weight_fun(Xweights,k)

% weight function to model empirical estimated weights
% first row: if the datapoint belongs to group1 or group2
% second row: the covariate value of corresponding datapoint 
    
group = Xweights(1,:);
Cov = Xweights(2,:);

n = size(Xweights,2);

alpha=zeros(1, n);
beta = ones(1,n)*2.54; % fitted values

alpha(group==1)=310.2; % fitted values
alpha(group==2)=87.8; % fitted values

    if k==2 % only for K = 2 valid      
         res = zeros(n,2);
         res(:,1) = betacdf(Cov',alpha', beta');
         res(:,2) = 1-res(:,1);  
    else
        warning('Investigations are only valid for K=2'); return
    end

end

