%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function datareg = DetermineSizes(datareg)
% determines sizes of sets with equal matrix X
% groups dataX, y, censor and Xweights first and determines then the correct sizes

% Input: 
%        datareg: structure containing fields
%                .y ... (1xN) vector of observed data
%                .X ... (dxN) Matrix of cofactors
%                .censor ... (1xN) vector indicating if observation is censored (optional)
%                .Xweights ... (pxN) matrix of cofactors for 'weightfun' (optional)

% Output:
%        datareg: structure containing sorted fields
%                .y ... (1xN) vector of observed data
%                .X ... (dxN) Matrix of cofactors
%                .censor ... (1xN) vector indicating if observation is censored (optional)
%                .Xweights ... (pxN) matrix of cofactors for 'weightfun' (optional)
   
if ~isfield(datareg, 'X') 
    warning('dataregX is missing.'); return 
else
    X=datareg.X;
end  
       
%group first data
for i=1:length(X(:,1))
    [~, ind] = sort(X(i,:));
    X=X(:,ind);
      
    % sorts y-vector
    datareg.y = datareg.y(ind); 
    % sorts censor-vector
    if isfield(datareg, 'censor') datareg.censor = datareg.censor(ind); end
    % sorts Xweights vector
    if isfield(datareg, 'Xweights') datareg.Xweights = datareg.Xweights(:,ind); end 
end

datareg.X=X;

check= zeros(1,size(datareg.X, 2)); 

for i = 1:length(check)
    fix= X(:,1);
    check=sum(((X-fix*ones(1, size(X, 2))).^2),1);
    ind=find(check);
    if isempty(ind)  
        sizes(i)=sizes(i-1)+length(check);
        datareg.sizes=sizes;
        return;
    else 
        if i==1
            sizes(i)=ind(1)-1;%length of dataset
        else
            sizes(i)=sizes(i-1)+(ind(1)-1); %length of dataset
        end
        X=X(:,ind(1):end);
        clear check;
    end
end

end 