
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function pweight = PostWeight(mcmcout,data)
% calculates the posterior weights for each set of test conditions for a
% MoE with fixed weights


breaks = data.sizes;
pweight = zeros(length(breaks),2);
for i=1:length(breaks)
    % excluding one dataset (= CTF_val, covar_val) for validation
    datanew = data;
    if i==1        
        datanew.y = data.y(1:breaks(i));
        if isfield(data,'X') datanew.X = data.X(:,1:breaks(i)); end
        datanew.N = size(datanew.y,2);
        datanew.S = mcmcout.clust.Smap(1:breaks(i));
        datanew.weight = mcmcout.prior.weight(1,:);
    else
        datanew.y = data.y((breaks(i-1)+1):breaks(i));
        if isfield(data,'X') datanew.X = data.X(:,(breaks(i-1)+1));end
        datanew.N = size(datanew.y,2);
        datanew.S = mcmcout.clust.Smap((breaks(i-1)+1):breaks(i));
        datanew.weight = mcmcout.prior.weight(breaks(i),:);
    end
    w = sum(datanew.S==1)/datanew.N;
    [x,id]=sort((datanew.weight-w).^2,'ascend');
    
    pweight(i,1)=sum(datanew.S==id(1))/datanew.N;
end
pweight(:,2)=1-pweight(:,1);
end