%	 Copyright (C) 2008  Frhwirth-Schnatter
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function [seblock, sechib]=chib_se(r,varargin)

B=nargin-1;
M=size(varargin{1},1);
h=zeros(M,B);
for b=1:B
    h(:,b)=varargin{b};
    h(:,b)=exp(h(:,b)-max(h(:,b)));
end

[ac, hm, sd,ki, varhhat, ineff] = autocov(h,r);
seblock=(diag(varhhat).^.5./hm)';
sechib=(((1./hm)'*varhhat*(1./hm))^.5);

