%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function [class, varargout]= dataclass_MOE(data,mix,varargin)

% Classify data through  of a finite mixture model, stored in the structure array mix
%
% variable output argument: simulate indicator from this density
% variable input argument: surpress computation of the smooting density to speed up MCMC
%
% modification takes censored data into account, but method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

  
if nargin==2 % check the dimension of the data
    % data are handled as data stored by row
    ibycolumn=isfield(data,'bycolumn');
    if ibycolumn  ibycolumn=data.bycolumn; end  % ibycolumn true: data stored by column
    if ibycolumn      data.y=data.y'; data.bycolumn ='false'; end
end

if ~isfield(mix,'K') mix.K=1;  end  % single member from the distribution family

if isfield(data,'t0') class.t0=data.t0; datat0=data.t0; else datat0=1; end


mix.type=mix.dist;

%%%%%%%%%%%%   compute the likleihood  l(y_i<|theta_k)  for all i and  forall k

y=data.y;

n = size(y,2);

nst=mix.K; 
if  mix.type(1:6)=='Normal'
    if isfield(mix,'d')   % mixture regression model
        if isfield(mix,'indexdf')  mix.df=size(mix.indexdf,1)*size(mix.indexdf,2); else  mix.df=0;     end

        if mix.df>0
            intercept=[1:mix.d];
            indexdr=intercept(all(repmat(mix.indexdf,1,mix.d)~=repmat(intercept,mix.df,1),1));
            mu=mix.par.beta'*data.X(indexdr,:);
            mu=mu+repmat(mix.par.alpha'*data.X(mix.indexdf,:),mix.K,1);
        else
            mu=mix.par.beta'*data.X;
        end
  
        modseq=struct('mu',mu','sigma',repmat(mix.par.sigma,n,1));
        
        % Modified by: Olivia Bluder Oct. 25, 2010
        if isfield(data,'censor')
            llh = normalpdflog_censor(modseq,repmat(data.y',1,mix.K),repmat(data.censor',1,mix.K))';
        else
            llh= normalpdflog(modseq,repmat(data.y',1,mix.K))';
        end
        % end modification
        
        maxl = max(llh,[],1);
        lh = exp(llh - maxl(ones(nst,1),:));
        
        %debugging
        if any(any(isnan(lh)))
            disp('')
        end
        % end debugging
        
    else  % finite mixture model
        [lh  maxl llh] = likeli_normal(y',mix.par.mu',mix.par.sigma');
        if size(nst,1)*size(nst,2)~=1  nst=max(nst); end
    end
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
else
    ['Mixture type ' mix.type ' not supported by function dataclass']
end

class.logpy=llh; % log-likelihood of the data given the fully specified model


if ~isfield(mix,'indicmod') mix.indicmod.dist='Multinomial';  end
if mix.K==1
    mix.weight=1;
end 
  
if ~isfield(mix,'indicfix') mix.indicfix=false; end

if ~mix.indicfix 
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %  Determine the posterior of the indicators
    % Modified by: Olivia Bluder Sept 20, 2010     
    if or(mix.indicmod.dist(1:6)=='Multin',isfield(mix,'MOE'))
        if   size(mix.weight,1)==1     mix.weight=mix.weight(ones(n,1),:);  end
     % end modification
        p = mix.weight'.*lh;
        sump=sum(p,1); 
        class.mixlik = sum(log(sump)+maxl);
        p = p ./ sump(ones(nst,1),:);
        class.prob = p';
 
        if nargout>1  % SIMULATE InDiCaTOR
            if max(mix.K) > 1
                rnd = rand(n,1);
                S = (sum(cumsum(class.prob,2) < rnd(:,ones(max(mix.K),1)),2) + 1)';      % sampling%sst 1 times n
                varargout{1}=S;               
            else
                varargout{1} = ones(1,n);
            end
            class.postS=sum(log(sum((repmat(varargout{1}',1,max(mix.K))==repmat([1:max(mix.K)],n,1)).*class.prob,2)));   % p(S|thmod,y)

        end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    else
        disp('Only implemented for mixtures-of-experts.')
    end
    %% compute  entropy

    logp=zeros(size(class.prob));
    for k=1:nst;
        logp(class.prob(:,k)==0,k)=-99;logp(class.prob(:,k)~=0,k)=log(class.prob(class.prob(:,k)~=0,k));
    end
 
    class.entropy= -sum(sum(logp.*class.prob));

end


%% compute complete data likelihood for indicators stored in data.S
% if new indicators were sampled in dataclass (i.e. if nargout>1 )  no
% complete data likelihood is computed


if nargout==1
    if  and(isfield(data,'S'),mix.K>1)
        indk=repmat(data.S,mix.K,1)==repmat([1:mix.K]',1,size(data.S,2));
        class.loglikcd=sum(indk.*class.logpy,2);
    else
        class.loglikcd=class.mixlik;
    end
end
