%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function varargout=dataplot_MoE(data,varargin);
% Plot data
     
if nargin==1 nfig=0; else nfig=fix(varargin{1})-1; end
      
% data are handled as data stored by row
ibycolumn=isfield(data,'bycolumn');
if ~ibycolumn  
    if size(data.y,1)==1
    data.bycolumn=false; 
    elseif size(data.y,2)==1
        data.bycolumn=true;
    else
       data.bycolumn=false;
    end
end  % ibycolumn true: data stored by column
if data.bycolumn  y=data.y'; else     y=data.y; end

if ~isfield(data,'r') data.r=size(y,1); end
r=data.r;
if ~isfield(data,'istimeseries') data.istimeseries=false; end
if ~isfield(data,'N') data.N=size(y,2); end

%%  time series plot

if  data.istimeseries
    % modification begin, Plankensteiner
    warn('Function is not implemented for time series.'); return
    % modification end, Plankensteiner
end

if ~isfield(data,'X')
    plotmarg=true;
else  % plot marginal density only, if regression model contains only intercept
    if all(all(data.X==1)) plotmarg=true; else plotmarg=false; end;
end  
 
if plotmarg 
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % loop over features and plot marginal distribution
    nfig=nfig+1; figure(nfig);
   
    if r==1
 

        % modification begin Plankensteiner
        % Function can only handle univariate continous data
            nbin=40;
            if data.N>1000   nbin=100; end
            histneu(y',nbin,'k');
        %modification end Plankensteiner

        if isfield(data,'model')    % adds (marginal) density plot for the model data.model
            hold on;
%            plotmod=true;
            if r==1 
                nfigneu= mixtureplot_MoE(data.model,nfig);
                %legend('observed','fitted')
                if nfigneu>nfig close([nfig+1:nfigneu]); end 
            else
                 % modification begin, Plankensteiner
                 warn('Function is not implemented for multivariate data'); return
                 % modification end, Plankensteiner
            end
            hold off;
        end


        if isfield(data,'name')  % adds title  for named data
             title(['Histogram of the ' data.name ' data']);
        end
       
    else
       % modification begin, Plankensteiner
        warn('Function is not implemented for multivariate data.'); return
        % modification end, Plankensteiner 
    end
end


if nargout==1 varargout{1}=nfig; end
