%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% DEMONSTRATION OF LINEAR REGRESSION MODELLING WITHOUT MIXTURES-OF-EXPERTS %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% NORMAL DISTRIBUTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
%% Obligatory fields of data 
%%% .y: 1 x N data vector
%%% .N: number of data
%%% .X: (d+1) x N matrix with covariate values and leadind 1
%%% .censor: 1 x N vector with 0 (datapoint uncensored) or 1 (datapoint
%%% censored)

%% Load data:

clear all
load('datareg_MoE.mat')
% there are two variables: data and data_future
% datareg: consits of - N: number of datapoints
%                  - y: datapoints
%                  - censor: vector 1xN with 0/1 declaring if datapoint i is censored (1) or is not censored (0)            
%                  - X: matrix with values of cofactors for regression (leading 1-row)
%                  - EmpEst_weights: empirical estimated weights (assuming
%                       that y follows a mixture of distributions (in this case K=2))
%                  - Cofactor_weights: values of cofactors for the regression model of mixture weights  
%                  - EmpEst_weightfun: function for empirical estimated weights (use EmpEst_weights)
%                  - Cofactor_weightfun: regression function for mixing weights (use Cofactor_weights)

% data_future: consitst of - N: number of new datapoints
%                          - y: real measured datapoints (for comparison with predicted data)     
%                          - X: values of cofactors for regression (leading 1-row)   
%                          - censor: vector 1xN with 0/1 declaring if datapoint i is censored (1) or is not censored (0) (for comparison with predicted data)     
%                          - MoE_Xweights: values of cofactors for the weights


%% Prepare data

data=datareg;
%%% delete variables which are not used at this point:
data = rmfield(data, 'EmpEst_weights');
data = rmfield(data, 'Cofactor_weights');
data = rmfield(data, 'EmpEst_weightfun');
data = rmfield(data, 'Cofactor_weightfun');

data_future=rmfield(data_future, 'MOE_Xweights');

%% SET PARAMETERS 

K=2; % data is a mixture of K distributions
M= 5000; % number of MCMC draws after burnin
burnin=1000;
name = 'mcmcout'; %define a name for the model 
comment = 'comment?'; % add a comment

 
%% DEFINE MODEL:
model.K=K;
model.dist='Normal';
model.d=size(data.X,1);


%% DEFINE PRIOR

%% Either use a default prior => a hierarchical normal prior: 
prior=priordefine_MOE(data, model);

%% OR
%%%% use a non hierarchical normal prior:
prior.hier = false;
prior=priordefine_MOE(data, model, prior);


%% INCLUDE PRIOR INFORMATION:
%%% AT THIS POINT A NORMAL PRIOR IS USED, because our prior information implies
%%% normal distribution N(mu, sigma^2):

%%%  we have no prior information for the intercept: b_{0,k}
%%%  we have prior information for b_{1,k}, b_{2,k} and b_{3,k}
%%%  
%%%  b_{1,k} ~ N(-1/3, 1);
%%%  b_{2,k} ~ N(-4.25, 0.44);
%%%  b_{3,k} ~ N(0.93, 0.25);
%%%   include the information in the defined prior:

prior.par.beta.b(2,:)=-1/3; 
prior.par.beta.b(3,:)=-4.25;
prior.par.beta.b(4,:)=0.93;
prior.par.beta.Binv(2,2,:)=1/1;
prior.par.beta.Binv(3,3,:)=1/0.44;
prior.par.beta.Binv(4,4,:)=1/0.25;  


%% DEFINE MCMC PROPERTIES:
[data, model, mcmc]= mcmcstart_MOE(data, model);
mcmc.M= M;  
mcmc.burnin=burnin;
mcmc.storeS=M; % to check allocations afterward
 

%% RUN MCMC:
mcmcout= mcmc_MOE(data, model, prior, mcmc); 


%% PLOT MCMC RESULTS:
mcmcplot_MOE(mcmcout)
 
%% CLASSIFY THE DATA BASED ON MCMC DRAWS & PLOT THE CLASSIFICATION PROBABILITIES & CLUSTERING RESULTS
clust= mcmcclust_MoE(data, mcmcout); % based on the posterior draws, the datapoints are clustered 
mcmcclustplot_MoE(data,clust); % now you can see the posterior allocation probabilities 
  

%% VALUE OF THE MARGINAL LIKELIHOOD:
[marlik,mcmcout]=mcmcbf_MOE(data,mcmcout); 


%% POSTERIOR ESTIMATES:
[est,mcmcout]=mcmcestimate_MOE(mcmcout); 

%% MODEL EVALUATION

% significance level for KS-test
alpha = 0.05;
PIT=PIT_mixtures(data, mcmcout,alpha);  % if model assumption is accurate, PIT values are uniformly distributed
% As you can see in the plot, the model assumption is accurate
% the output gives you a summary about the PIT values statistic

%% GOODNESS OF FIT CRITERIA:
[ic,mcmcout]=mcmcic_MOE(data,mcmcout); 
    

%% STORE RESULTS:
mcmcout.data=data;
mcmcout.name= name;
mcmcout.comment = comment;
mcmcstore(mcmcout);
 

%% PREDICTION:
%%% predict new data: 'data_future' and compare with real observation:
[fig,pred]=mcmcpreddens_MOE(data_future, mcmcout);


%% PERFORM CROSS VALIDATION:

CrossVal=CrossValidation_MOE(data, 'mcmc_MOE', model, prior);