%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% demo for finite mixtures of multiple regression models without fixed effects
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% simulate data 
   
% define the true regression model
 
clear all;
mixregtrue.dist='Normal';
mixregtrue.K=2;               
mixregtrue.weight=[0.3 0.7 ];
mixregtrue.par.sigma=[1. 0.9]; 
 
% crossing lines: 
% mixregtrue.par.beta=[0 4 ;1 -2; 0.3 0.1; 3 7];
% non-crossinglines: 
mixregtrue.par.beta=[-2 3 ;1 -2; -3 2];

mixregtrue.d=size(mixregtrue.par.beta,1);

datareg=simulate_MoE(mixregtrue,1000);
data_future= simulate_MoE(mixregtrue,100);

clear mixregtrue;

ksdensity(datareg.y);

%% SET PARAMETERS & DEFINE MODEL:

M= 5000; % number of MCMC draws after burnin
burnin=1000;
 
mixreg.d=size(datareg.X,1);
mixreg.dist='Normal';
mixreg.K=2; % data is a mixture of K distributions

name = 'mcmcout'; %define a name for the model 
comment = 'comment?'; % add a comment
%% DEFINE PRIOR

%% Either use a default prior => a hierarchical normal prior: 
prior=priordefine_MOE(datareg, mixreg);

%% OR
%%%% use a non hierarchical normal prior:
prior.hier = false;
prior=priordefine_MOE(datareg, mixreg, prior);

%% DEFINE MCMC PROPERTIES:
[datareg,mixreg,mcmc]=mcmcstart_MOE(datareg,mixreg);
mcmc.M=M;
mcmc.burnin=burnin;
mcmc.storeS=M; 

    
%% RUN MCMC.
mcmcout=mcmc_MOE(datareg,mixreg,prior,mcmc);


%% PLOT MCMC RESULTS:
mcmcplot_MOE(mcmcout)


%% CLASSIFY THE DATA BASED ON MCMC DRAWS & PLOT THE CLASSIFICATION PROBABILITIES & CLUSTERING RESULTS
clust= mcmcclust_MoE(datareg, mcmcout); % based on the posterior draws, the datapoints are clustered - due to the data amount, this can take some minutes
mcmcclustplot_MoE(datareg,clust); % now you can see the posterior allocation probabilities 
 
%% VALUE OF THE MARGINAL LIKELIHOOD:
[marlik,mcmcout]=mcmcbf_MOE(datareg,mcmcout); 
 
%% POSTERIOR ESTIMATES:
[est,mcmcout]=mcmcestimate_MOE(mcmcout);  
% poterior mode estimates for weight eta:
est.pm.weight
% compare with true weight
datareg.model.weight
 
% posterior mode estimate for beta:
est.pm.par.beta
% compare with true beta
datareg.model.par.beta

%% MODEL EVALUATION

% significance level for KS-test
alpha = 0.05;
PIT=PIT_mixtures(datareg, mcmcout,alpha);  % if model assumption is accurate, PIT values are uniformly distributed
% As you can see in the plot, the model assumption is accurate
% the output gives you a summary about the PIT values statistic

%% GOODNESS OF FIT CRITERIA:
[ic,mcmcout]=mcmcic_MOE(datareg,mcmcout); % goodness of fit criteria are determined. Criteria are determined with the posterior draw, that gives the best likelihood
 
%% STORE RESULTS:
mcmcout.data=datareg;
mcmcout.name= name;
mcmcout.comment = comment;
mcmcstore(mcmcout);
 

%% PREDICTION:
%%% predict new data: 'data_future' and compare with real observation:
[fig,pred]=mcmcpreddens_MOE(data_future, mcmcout);


%% PERFORM CROSS VALIDATION:

CrossVal=CrossValidation_MOE(data, 'mcmc_MOE', model, prior);


