%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function fl = dirichpdflog(par,eta)
% computes the logarithm of a Dirichlet posterior density 
 
% input
% par ... parameter of the aposteriori density, the number of colums
%         determines the  number of categories
% eta ... arguments of the  aposteriori density

%output: log of the posteriro density
%        M times 1 array with M being the maximum number of row in par and
%        eta

if ~(size(par,2)==size(eta,2))     warn(['Size disagreement in function dirichpdflog']); fl=[]; return; end

if size(par,1)==1  % evaluate a single density at a sequence of draws
    
   par=repmat(par,size(eta,1),1);

elseif size(eta,1)==1  % evaluate a sequence of density at a single draw
    
   eta=repmat(eta,size(par,1),1);
    
elseif ~(size(par,1)==size(eta,1))
    warn(['Size disagreement in function dirichpdflog']); fl=[]; return
else    
%    evaluate  density in row i at the corresponding draw in row i
end

fl=gammaln(sum(par,2))+sum((par-1).*log(eta)-gammaln(par),2);

