%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function simout = dirichsim(par,varargin)
% simulates from a Dirichlet posterior density 

% input
% par ... parameter of the aposteriori density, the number of colums
%         determines the  number of categories
%
% for two argument:  varargin determines the number of draws, otherwise it assumed that a single darw is required  

% output: simout ... simulated values  (varargin times K)  array 

if nargin==2     
    M=varargin{1}; 
    if and(size(par,1)~=M,size(par,1)~=1)   warn(['Size disagreement in the variable par in function dirichsim']); fl=[]; return;     end 
else 
    M=size(par,1); 
end

cat=size(par,2);


if size(par,1)==1  %  a sequence of M draws from a single density  
    
    gam = gamrnd(repmat(par,M,1),1);
    simout = gam ./ repmat(sum(gam,2),1,cat);
    
    
else  % a single draw from a sequence of densities
    
    gam = gamrnd(par,1);
    simout = gam ./ repmat(sum(gam,2),1,cat);
    
end

