%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function histneu(x,k,cl)
% 
% plot a histogram of the data 
% modification of the matlab function hist

% x ... observations
% k ... number of bins
% cl ... color of plot

[nh,bc] = hist(x,k);
dx=bc(2)-bc(1);
d=nh/sum(nh)/dx;
c=[bc-dx*0.5 bc(end)+dx*0.5];
for i=1:k
   plot([c(i) c(i+1)],[d(i) d(i)],cl)
   hold on
   plot([c(i) c(i)],[0 d(i)],cl)
   plot([c(i+1) c(i+1)],[0 d(i)],cl)
end
hold off;
