%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function lh = likelihoodeval_MOE(data,mix)

% computes the log likelihood of model mix

lh=0;    
 
if isfield(data,'empty') if data.empty return; end; end
    
if ~isfield(mix,'indicfix') mix.indicfix=false; end
if ~isfield(mix,'K') mix.K=1; end

% modified by: Olivia Bluder Sept 29, 2010 
class=dataclass_MOE(data,mix,0);
% end modification

if or(~mix.indicfix,mix.K==1)     
    %  compute the log likelihood for a model with K=1 or
    %  the log mixture likleihood for a mixture model with unknown allocations
    % 
    
    lh=class.mixlik; 
else  
    % computes the log of the complete data likelihood for a mixture model
    % with known allocations

    lh=sum(class.loglikcd);
end        
        
   
    
