%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function mcmcout=mcmc_MOE(data,mix,prior,mcmc,varargin)      
% Run MCMC for a finite mixture of experts model with non-conjugate priors
 
% modifications take censored data into account => method can only handle regression
% models or MoE models based on univariate Gaussian data
            
rand('state',sum(100*clock)) ; 
randn('state',sum(100*clock)) ;

%%%%%%%%%%%  CHECK INPUT  
 
if ~isfield(mix,'dist')  
    warn('The field dist is obligatory in the structure array defining the mixture when calling the function priordefine'); return; 
end

% modefied by plankensteiner begin
if ~isfield(mix,'dist') 
    warn('The field dist is obligatory in the structure array defining the mixture when calling the function priordefine')
    mcmcout=[];return
end 

if ~all(mix.dist(1:6)=='Normal')
    warn('Function is only implemented for mixtures of normal distributions.')
    mcmcout=[];return
end

if ~isfield(mix,'d')
    warn('Function is only implemented for regression models.')
    mcmcout=[];return 
end
% modefied by plankensteiner end

if ~isfield(mix,'K') mix.K=1;  end  % single member from the distribution family

if ~strcmp(prior.type,'indep') warn('this function is not implemented for this prior.type'); mcmcout=[]; return; end

if and(~isfield(mix,'weight'),mix.K==1) mix.weight=1;  end
  
if and(~isfield(mix,'indicmod'),mix.K>1)   % default: mulinomial for indicators
    mix.indicmod.dist='Multinomial';
    mix.indicmod.cat=mix.K;
    mix.indicmod.T=1;
elseif and(isfield(mix,'indicmod'),mix.K>1)
    if ~isfield(mix.indicmod,'init') mix.indicmod.cat=mix.K;  end
    if ~isfield(mix.indicmod,'T') mix.indicmod.T=1;    end
end

if ~isfield(data,'N') data.N=size(data.y,2); end 

if ~isfield(mix,'omega')  mix.omega=ones(1,data.N); end

if ~isfield(mix,'error')  % Normal or student mixture; default: switching variance
    mix.error='switch';
end

if ~isfield(data,'empty') data.empty=false; end
if ~isfield(mcmc,'PX') mcmc.PX=false; end

% data are handled as data stored by row
if isfield(data,'bycolumn') ibycolumn=data.bycolumn; else ibycolumn=false; end  % ibycolumn true: data stored by column
if ibycolumn
    data.y=data.y';
    if isfield(data,'X') data.X=data.X'; end
    data.bycolumn =false;
end
if ~isfield(data,'y')
    warn('The field y is obligatory in the structure array defining the data when calling the function mixturemcmc')
    mcmcout=[];return
end

if ~isfield(data,'r') data.r=size(data.y,1); end
if ~isfield(mix,'r') mix.r=data.r;  end  % single member from the distribution family
mcmcout=struct('model',struct('dist',mix.dist,'r',mix.r),'prior',prior,'M',mcmc.M);

ihier=isfield(prior,'hier');if ihier ihier=prior.hier;end   % ihier true: hierarchical prior

if isfield(mix,'parfix')
    if isfield(mix.parfix,'df')
        dffix=mix.parfix.df;
        mcmcout.model.parfix.df=true;
        mcmcout.model.par.df=mix.par.df;
    else
        dffix=false;
    end
    if isfield(mix.parfix,'mu')
        mufix=mix.parfix.mu;
        mcmcout.model.parfix.mu=true;
        mcmcout.model.par.mu=mix.par.mu;
    else
        mufix=false;
    end
    if isfield(mix.parfix,'sigma')
        sigmafix=mix.parfix.sigma;
    else
        sigmafix=false;
    end
else
    dffix=false;
    mufix=false;
    sigmafix=false;
end

if mix.K>1
    mcmcout.model.K=mix.K;
    % Modified by: Olivia Bluder Sept 21, 2010
    if isfield(mix,'MOE')
        mcmcout.model.MOE = true;
        if strcmp(mix.indicmod.dist(1:6),'FixedW')
            mcmcout.model.indicmod=struct('dist','FixedW');
        else
            disp ('MOE non-fixed weight not implemented yet')
        end
    end
    % end modification
    
    if isfield(mix,'indicfix')     mcmcout.model.indicfix=mix.indicfix;   end
else
    if isfield(data,'S') data=rmfield(data,'S'); end
    data.S=ones(1,size(data.y,2));
end

if isfield(mix,'indexdf') mcmcout.model.indexdf=mix.indexdf; mix.df=size(mix.indexdf,1)*size(mix.indexdf,3); else mix.df=0; end
if isfield(mix,'d')  mcmcout.model.d=mix.d; end

if ~isfield(mix,'indicfix')  mix.indicfix=false;   end

if and(mix.K>1,~mix.indicfix)
    mcmcout.log=struct('mixlik',zeros(mcmc.M,1),'mixprior',zeros(mcmc.M,1),'cdpost',zeros(mcmc.M,1));
    mcmcout.entropy=zeros(mcmc.M,1);
    mcmcout.ST=zeros(mcmc.M,1);
else
    mcmcout.log=struct('mixlik',zeros(mcmc.M,1),'mixprior',zeros(mcmc.M,1));
end

if ~isfield(mcmc,'burnin') mcmc.burnin=0; end

istorepost=isfield(mcmc,'storepost');if istorepost istorepost=mcmc.storepost;end
istoreinv=isfield(mcmc,'storeinv');if istoreinv istoreinv=mcmc.storeinv;else istoreinv=true;end

post.par.empty=true;

if or(mix.indicfix,mix.K==1)  mcmc.ranperm=false; end

iperm=isfield(mcmc,'ranperm');if iperm iperm=mcmc.ranperm;else iperm=true; end  % iperm true: random permuation sampling


if and (mix.d==1,~isfield(data,'X')) 
    data.X=ones(1,data.N); 
end

istoreS=isfield(mcmc,'storeS');if istoreS istoreS=fix(mcmc.storeS);mcmcout.S=zeros(istoreS,data.N);end   % ihier true: hierarchical prior

%%%  check if all starting values have been defined

istartpar=isfield(mcmc,'startpar'); if istartpar istartpar=mcmc.startpar;end

if and(and(istartpar,~mix.indicfix),mix.K>1)  % start with sampling the allocations, check if Starting values for the parameter have been defined,
    if ~isfield(mix,'par')
        warn('Starting values for component parameters have to be assigned to the field par in the structure array defining the mixture')
        mcmcout=[];return;
    elseif and(~isfield(mix,'weight'),mix.indicmod.dist(1:6)=='Multin')
        warn('Starting value for the weight distribution has to be assigned to the field weight in the structure array defining the mixture')
        mcmcout=[];return;
    else 
        [class S] =dataclass_MOE(data,mix,0);
        if  strcmp(mix.indicmod.dist(1:6),'Multin')
            data.S=S;
        end
    end
else
    if and(~isfield(data,'S'),mix.K>1)
        warn('Starting value for the classification has to be assigned to the field S in the structure array defining the data')
        mcmcout=[];return;
    end
    
        % modify by plankensteiner begin
        if ~isfield(prior,'init')
            prior.init.beta = zeros(mix.K,mix.d)';
            
            % take estimated means for intercept
            obj = gmdistribution.fit(data.y',mix.K);
            prior.init.beta(1,:)=sort(obj.mu);
            prior.init.sigma = 10*ones(1,mix.K);
            prior.init.C=5*ones(1,mix.K);
            warning(strcat('Initial values for slice sampler are missing, for each component default ones are used.'))
        end
        %modify by plankensteiner end
        
        if ~isfield(mix,'par')
            warn('Starting values for error variances have to be assigned to the field par.sigma in the structure array defining the mixture regression model');mcmcout=[];return;
        elseif ~isfield(mix.par,'sigma')
            warn('Starting values for error variances have to be assigned to the field par.sigma in the structure array defining the mixture regression model');mcmcout=[];return;
        end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% START WITH MCMC

% Modified by: Olivia Bluder Oct. 18, 2010 
% for censored data the slice sampler will be used and samples after burnin will be stored in Sperm
if isfield(data,'censor')
    % is used for the slice sampling algorithm    
    if nargin >= 5     Sperm = varargin{1};    end
    % location of next free row to save permuation
    Sperm.index_perm = 1;
    % structure array to store the samples for each permutation
    Sperm.sample=cell(mix.K,mcmc.M);
    % burnin for slice sampler  
    if ~isfield(Sperm,'burnin') Sperm.burnin = 500; end
end
% end modification

t0 = clock;
tlast=t0;
for m=1:(mcmc.burnin+mcmc.M)
 
    if etime(clock,tlast)>180
        ext=fix(etime(clock,t0)/m*(mcmc.burnin+mcmc.M-m));
        ['estimated completion in about ' num2str(fix(ext/60))   ' minutes  and ' num2str(ext-fix(ext/60)*60) ' seconds']
        tlast = clock;
    end

%% Sample the weight distribution
  
    if and(mix.K>1,~mix.indicfix)

        if  strcmp(mix.indicmod.dist(1:6),'Multin')

            %  complete data posterior for the weights
            dataS.y=data.S;
            if data.empty  dataS.empty=true; else dataS.empty=false; end    % data may be ignored for testing purposes
            post.weight=posterior_MOE(dataS,mix.indicmod,prior.weight,0);

            eta=dirichsim(post.weight);

            mix.weight = eta;
             
        % modified by Bluder, Sept. 20, 2010    
        elseif isfield(mix,'MOE')
            if ~isfield(mix.indicmod, 'dist')
                disp('no indicmod specified for MOE model')
                return;
            elseif mix.indicmod.dist(1:6)=='FixedW'
                if m==1
                    mix.weight = prior.weight;
                    post.weight = prior.weight;  
                end
            else
                disp('MOE for non-fixed weigths not implemented yet')
            end
        % end modification
        
        else
            disp('Function not implemented for this purpose.'); return
        end
    end
    
    %%   sample the paramters
    %% finite mixtures of  multiple regression models
    
    if ~isfield(mix,'df') mix.df=0; end
    
    if ~isfield(mix,'parfix')
        mix.parfix.sigma=false; mix.parfix.beta=false;
    else
        if ~isfield(mix.parfix,'beta')  mix.parfix.beta=false; end
        if ~isfield(mix.parfix,'sigma')  mix.parfix.sigma=false; end
    end
    
    % Modified by: Olivia Bluder Sept. 20, 2010
    if ~isfield(data,'censor')
        if ~mix.parfix.beta
            if mix.df==0
                % simulate regression coefficients for a mixture of regression  models
                modreg=mix; modreg.parfix.sigma=true;
                % modified by Bluder, Sept. 20, 2010
                post.par.beta=posterior_MOE(data,modreg,prior.par.beta);
                % end modification
                if size(post.par.beta.B,1)>1
                    mix.par.beta=prodnormultsim(struct('mu',post.par.beta.b,'sigma',post.par.beta.B));
                else
                    mix.par.beta=prodnormultsim(struct('mu',post.par.beta.b,'sigma',squeeze(post.par.beta.B)'));
                end
                
            else   %  mixed-effects mixture of regression  models
                warn('Function not implemented for this case.')
                % simulate regression coefficients for a mixed-effects mixture of regression  models
                % by constructing a single large multiple regression model with heteroscedastic errors
            end
        end 
        
        % simulate error variances
        if ~mix.parfix.sigma
            modreg=mix;
            modreg.parfix.beta=true;
            if mix.df>0 modreg.parfix.alpha=true; end
            % modified by Bluder, Sept. 20, 2010
            post.par.sigma = posterior_MOE(data,modreg,prior.par.sigma);
            % end modification
            mix.par.sigma=1./prodgamsim(struct('a',post.par.sigma.c,'b',post.par.sigma.C));
        end
    else
       
        [mix.par, Sperm, prior, post] = posteriorSS(data, mix, prior, post, Sperm);
        
        % error handling for slice sampler
        if isempty(mix.par)
            warn('no slice sampling performed')
            return;
        end
        
        % looks for empty entries
        Empty_k = isnan(mix.par.sigma);
        
        % update initial values
        if m<=mcmc.burnin+1
            mixbeta = mix.par.beta;
            mixbeta(:,Empty_k) = prior.init.beta(:,Empty_k);
            mixsigma = mix.par.sigma;
            mixsigma(Empty_k) = prior.init.sigma(Empty_k);
            % mean of all sampled paramters is new initial
            % value => more robust than last value
            prior.init.beta = (prior.init.beta*(m-1)+mixbeta)./m;
            prior.init.sigma = (prior.init.sigma*(m-1)+mixsigma)./m;
            if prior.hier
                mix.par.C0(Empty_k) = prior.init.C(Empty_k);
                prior.init.C = (prior.init.C*(m-1)+mix.par.C0)./m;
            end
            if m == mcmc.burnin+1
                disp('%%%%%%%%%% burnin done %%%%%%%%%%%')
            end
        else
            Sperm.index_perm = Sperm.index_perm+1;
            % after burnin initial values restart from sampled values.
            % The mean of the last 100 samples is used (if existent).
            excl_nan = ~isnan(mcmcout.par.sigma(:,:));
            int_init = max(1,m-mcmc.burnin-101):m-mcmc.burnin-1;
            if or(mix.d ==1, mix.K==1)
                prior.init.beta = squeeze(mean(mcmcout.par.beta(excl_nan(int_init),:,:),1))';
            else
                prior.init.beta = squeeze(mean(mcmcout.par.beta(excl_nan(int_init),:,:),1));
            end
            prior.init.sigma = mean(mcmcout.par.sigma(excl_nan(int_init),:),1);
            if prior.hier
                mix.par.C0(Empty_k) = prior.init.C(Empty_k);
                prior.init.C = (prior.init.C*(m-1)+mix.par.C0)./m;
            end
        end
    end
    % end modification
    
    % modified Plankensteiner
    if ihier   % hierarchical prior
        %end modification plankensteiner
        % unrestricted Covariances
        
        if ~data.empty  gN=sum(prior.par.sigma.c,2)+prior.par.sigma.g; else gN=prior.par.sigma.g;  end
        
        if size(data.y,1)==1
            if ~data.empty
                GN=prior.par.sigma.G + sum(1./mix.par.sigma,2);
                
            else
                GN=prior.par.sigma.G;
            end
            prior.par.sigma.C=gamrnd(gN,1)/GN*ones(1,mix.K);
        else
            if ~data.empty
                GN=prior.par.sigma.G + squeeze(sum(mix.par.sigmainv,3));
            else
                GN=prior.par.sigma.G;
            end 
            [~, prQS detprQS] = invwisim(gN,GN); 
            prior.par.sigma.C=reshape(repmat(prQS,1,mix.K),size(data.y,1),size(data.y,1),mix.K);
            prior.par.sigma.logdetC= repmat(detprQS,1,mix.K);
        end
    end  
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% simulate allocations and compute mixture likleihood
     
    if ~mix.indicfix
        %
        [class, S] = dataclass_MOE(data,mix,0);
        % end modification
        mixlik=class.mixlik;
    else
        S=data.S;
        mixlik=likelihoodeval(data,mix);
    end
    % modified by O. Bluder Sept. 20, 2010
    mixprior=prioreval_MOE(mix,prior);
    % end of modification
    
    %% permute
    
    if iperm  % draw a random permuation if iperm true
        % modified by O. Bluder Sept. 20, 2010
        ranpermute_MOE;
        % end modification
    else
        rho=[1:mix.K]';
    end
    
    if mix.K>1
        [~,srho]=sort(rho);
        % modified by O. Bluder Sept. 20, 2010
        if  or(mix.indicmod.dist(1:6)=='Multin', isfield(mix,'MOE'))
        % end modification
            data.S=srho(S)';
        end
    end
 
%% store results
    
    if m>mcmc.burnin
        % modified by O. Bluder Sept. 20, 2010
        mcmcput_MOE;
         
        mcmcout.log.mixprior(m-mcmc.burnin)=mixprior;

        if data.empty  %data may be ignored for testing purposes
            mcmcout.log.mixlik(m-mcmc.burnin)=0;
        else
            mcmcout.log.mixlik(m-mcmc.burnin)=mixlik; % mixture likelihood log p (y|thmod)
        end

        if and(mix.K>1,~mix.indicfix)
            % further results for mixture model with unknwon indicator
            mixpost=mcmcout.log.mixlik(m-mcmc.burnin)+mcmcout.log.mixprior(m-mcmc.burnin);
            mcmcout.log.cdpost(m-mcmc.burnin)=mixpost+class.postS; % complete data posterior prior log p (thmod m,S|y)), prior marginalized with respect
            % to the hyperparameter;  based on p(S,\thmod|\ym)=p(S|\thmod,\ym)* p(\thmod|\ym)\propto p(S|\thmod,\ym)* p(\ym|\thmod)*p(\thmod)
            if (m-mcmc.burnin)==1  maxcdpost=mcmcout.log.cdpost(1)-1;   end
            if mcmcout.log.cdpost(m-mcmc.burnin)> maxcdpost
                mcmcout.clust.Smap=data.S;
            end
            mcmcout.entropy(m-mcmc.burnin)=class.entropy;
            mcmcout.ST(m-mcmc.burnin)=data.S(end);

            if  m>(mcmc.M+mcmc.burnin-istoreS)  mcmcout.S(m-(mcmc.M+mcmc.burnin-istoreS),:)=data.S;     end
        end
    end
end

if mix.K>1 mcmcout.ranperm=iperm;end


