%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function mix=mcmcaverage_MOE(mcmcout)
% Compute the average of the MCMC draws,result stored as mixture 

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data

mix.dist=mcmcout.model.dist;
if isfield(mcmcout.model,'K') 
    mix.K=mcmcout.model.K; 
else
    mcmcout.model.K=1;
end
if isfield(mcmcout.model,'indicmod')
     % modified by: Olivia Bluder Sept 21, 2010    
    if isfield(mcmcout.model,'MOE')
        mix.MOE = true;
        if mcmcout.model.indicmod.dist(1:6)=='FixedW'
            mix.indicmod = struct('dist','FixedW');
        else
            disp('MOE with non-fixed weights not implemented yet')
        end
    % end modification
    end
else
    mcmcout.model.indicmod.dist='Multinomial';
end    
if isfield(mcmcout.model,'indicfix') 
    mix.indicfix=mcmcout.model.indicfix;   
else
    mcmcout.model.indicfix=false;
end

 if isfield(mcmcout.model,'d')  mix.d=mcmcout.model.d; end
 if isfield(mcmcout.model,'par') if isfield(mcmcout.model.par,'indexar')  mix.par.indexar=mcmcout.model.par.indexar; end; end


if ~isstruct(mcmcout.par) 
    mix.par=mean(mcmcout.par,1);
    
else
    if isfield(mcmcout.par,'beta') 
        if size(mcmcout.par.beta,2)>1
            mix.par.beta=squeeze(mean(mcmcout.par.beta,1));
        else
            mix.par.beta=squeeze(mean(mcmcout.par.beta,1))';
        end
    end
    
    if isfield(mcmcout.par,'sigma')
            mix.par.sigma=mean(mcmcout.par.sigma,1);
    end
end

if mcmcout.model.K>1
    if ~mcmcout.model.indicfix
         if mcmcout.model.indicmod.dist(1:6)=='Multin' 
        % modified by: Olivia Bluder Sept 21, 2010    
        elseif  isfield(mcmcout.model,'MOE')
            mix.MOE = true;
            if mcmcout.model.indicmod.dist(1:6)=='FixedW'
                mix.weight = mcmcout.weight;
            else
                disp('MOE with non-fixed weights not implemented yet')
            end
        end
    end
end



