%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function varargout=mcmcclustplot_MoE(data,clust,varargin)
% Visualize posterior clustering and time series segmentation
% Function is restricted to data.r=1 
    
if nargin==2 
    ifig=1;
elseif nargin==3
    ifig=fix(varargin{1})+1;
end    
   
% data are handled as data stored by row
ibycolumn=isfield(data,'bycolumn');
if ibycolumn  ibycolumn=data.bycolumn; end  % ibycolumn true: data stored by column 
if ibycolumn      data.y=data.y'; data.bycolumn ='false'; end   

ibycolumn=isfield(data,'bycolumn');
if ibycolumn  ibycolumn=data.bycolumn; end  % ibycolumn true: data stored by column 
if ibycolumn      data.y=data.y'; data.bycolumn ='false'; end   
if ~isfield(data,'t0') data.t0=1; end

if ~isfield(data,'r') data.r=size(data.y,1); end

if isfield(data,'X') 
    if all(all(data.X==1)) 
        regression = false;
        data=rmfield(data,'X') 
    else
        regression = true;
    end 
end

if ~isfield(data,'istimeseries') data.istimeseries=false; end
K=size(clust.prob,1);
N=size(clust.prob,2);
if ~isfield(clust,'t0') clust.t0=1; end
T=clust.t0-1+N;
  
if  clust.t0>data.t0
    data.y=data.y(:,clust.t0:end);
    data.N=size(data.y,2);
    if isfield(data,'X') data.X=data.X(:,clust.t0:end); end
elseif  clust.t0<data.t0
    warn(['Size disagreement between S and data.y in funtion clustplot']);return;
end

% modification begin, Plankensteiner
if data.istimeseries
   warn('Function mcmcclustplot is not implemented for times series data.'); return 
end

if data.r >1
 % multivariate data  
  warn('Function mcmcclustplot is not implemented for multivariate data.'); return
end

if regression 
    Xreal=data.X; 
    data.X=ones(1, data.N); 
end 
% modification end, Plankensteiner 

figure(ifig);
[ys is]=sort(data.y'); 
        
for k=1:K
    subplot(K,1,k);
     % bar(ys,clust.prob(k,is)');
    scatter(ys,clust.prob(k,is)');
    if k==1 title('Estimated Classification Probabilities'); end
    axis([min(data.y)-1 max(data.y)+1 0 1]);
    xlabel('observation y_i');
    ylabel(['Prob(S_i=',num2str(k),'|y_i)']);
end
        
ifig=ifig+1;
figure(ifig);

for j=1:3 
    if j==1 
        subplot(3,1,1);    
        plotclasscross(data.y,clust.Smap); 
        title('Clustering based on Bayesian MAP');
    elseif j==2 
        subplot(3,1,2);    
        plotclasscross(data.y,clust.Sident); 
        title('Clustering based on the Misclassification Rate');
    elseif and(j==3,isfield(clust,'Ssim'))
        subplot(3,1,3);    
        plotclasscross(data.y,clust.Ssim); 
        title('Clustering based on the Similarity Matrix');
    end
end         

if regression
    % modification begin, Plankensteiner
    data.X= Xreal;
    % modification end, Plankensteiner
    
    index=[1:size(data.X,1)];
    ic= any(data.X~=1,2);
    X=data.X(ic,:);
    
    
    [nr, nc]=plotsub(size(X,1));
    
    for j=1:2+isfield(clust,'Ssim') 
        if j==1 
            S=clust.Smap; 
        elseif j==2 
            ifig=ifig+1; 
            S=clust.Sident; 
        elseif j==3
            ifig=ifig+1; 
            S=clust.Ssim; 
        end
        K=max(S);
        c=['b';'r';'g';'y';'k';'m'];
        if K>6 'K too large in mcmcclustplot' ,end
        
        figure(ifig);
        for ii=1:size(X,1)
            subplot(nr,nc,ii);
            for k=1:K
                if sum(S==k)>0  scatter(X(ii,S==k),data.y(:,S==k),[c(k,:)]);hold on; end
            end
            xlabel(['x_' num2str(ii)]);
            ylabel(['y']);
            cc=0.5;
            axis([min(X(ii,:)-cc,[],2)  max(X(ii,:)+cc,[],2)  min(data.y-cc,[],2)  max(data.y+cc,[],2)]);
            if ii==1 
                if j==1 
                    title('Clustering -- Bayesian MAP');
                elseif j==2 
                    title('Clustering -- Misclassification Rate');
                elseif j==3 
                    title('Clustering -- Similarity Matrix');
                end
            end    
        end      
    end
end        

if nargout==1
    varargout{1}=ifig;
end    
