%	 Copyright (C) 2008  Frhwirth-Schnatter
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function lossim= mcmcclustsim(S,K)
% classification based on the similarity matrix
% computes the loss function

N=size(S,2);
SM=size(S,1);
Wloss= zeros(N);  
index=[1:N];
for m=1:SM;
    ['m = ' num2str(m) '(max:' num2str(SM) ')']
    for k=1:K
        id=index(S(m,:)==k); % index  of all observations in group k
        Wloss(id,id)=Wloss(id,id)+1;
    end
end
%  Wloss/SM ...  approximate similarity matrix
Wloss=1-2*Wloss/SM; 

lossim=zeros(SM,1); 
for m=1:SM;
    ['m = ' num2str(m) '(max:' num2str(SM) ')']
    for k=1:K
        id=index(S(m,:)==k);
        lossim(m)=sum(sum(Wloss(id,id)));
    end
end
