%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function [est,varargout]=mcmcestimate_MOE(mcmcout)    

% Derive parameter estimates from MCMC draws for a finite mixture model 
    
% modified, such that method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

if ~isfield(mcmcout.model,'indicfix')  
    indicfix=false; 
else
    indicfix=mcmcout.model.indicfix;
end
if ~isfield(mcmcout.model,'indicmod') 
    indicmod.dist='Multinomial';  
else
    indicmod.dist=mcmcout.model.indicmod.dist;
end
 
mcmcout.est.pm=mcmcpm_MOE(mcmcout);

[logm is]=sort(mcmcout.log.mixlik);
pmdraw=is(end);
mcmcout.est.ml=mcmcextract_MOE(mcmcout,pmdraw);
 
average=mcmcaverage_MOE(mcmcout);

if isfield(mcmcout.model,'K')   K=mcmcout.model.K; else      K=1; end    

if or(K==1,indicfix)  % mixture model with known indicators or no mixture
    mcmcout.est.ident=average;
elseif ~indicfix    % model identification for mixture models
    if     mcmcout.ranperm==false
        mcmcout.est.average=average;
    else 
        mcmcout.est.invariant=average;
    end   
    if mcmcout.ranperm
        % modified by: Olivia Bluder Sept 21, 2010 
        if ~isfield(mcmcout,'perm') mcmcout=mcmcpermute_MOE(mcmcout); end
        % end modification 
        if mcmcout.Mperm>0 
         if indicmod.dist(1:6)=='Multin'
             mcmcout.est.ident=mcmcaverage_MOE(struct('model',mcmcout.model,'M',mcmcout.Mperm,'par',mcmcout.parperm,'weight',mcmcout.weightperm));
        % modified by: Olivia Bluder Sept 21, 2010    
         elseif isfield(mcmcout.model,'MOE')
            if mcmcout.model.indicmod.dist(1:6)=='FixedW'
                mcmcout.est.ident=mcmcaverage_MOE(struct('model',mcmcout.model,'M',mcmcout.Mperm,'par',mcmcout.parperm,'weight',mcmcout.weightperm));
            else
                disp('MOE with non-fixed weights not implemented yet')
            end
        % end modification
         end
        else
             warn('No identification possible, not a single draw is a permutation in the function mcmcpermute');
        end
    end
end

est=mcmcout.est;
if nargout==2
    varargout{1}=mcmcout;
end    