%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function mix=mcmcextract_MOE(mcmcout,m)

% stores the m-th MCMC draw as mixture model
% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data

mix.dist=mcmcout.model.dist;
if ~isfield(mcmcout.model,'K')  mcmcout.model.K=1; end
mix.K=mcmcout.model.K; 

mix.r=mcmcout.model.r;


 if isfield(mcmcout.model,'indicmod')
 
    % modified by: Olivia Bluder Sept 21, 2010    
    if isfield(mcmcout.model,'MOE')
        mix.MOE = true;
        if mcmcout.model.indicmod.dist(1:6)=='FixedW'
            mix.indicmod = struct('dist','FixedW');
        else
            disp('MOE with non-fixed weights not implemented yet')
        end
    % end modification
    
    end
 else
     mix.indicmod.dist='Multinomial';
     mcmcout.model.indicmod.dist='Multinomial';
 end    
if isfield(mcmcout.model,'indicfix')  
    mix.indicfix=mcmcout.model.indicfix;   
else
    mcmcout.model.indicfix=false;
end

if isfield(mcmcout.model,'d')  mix.d=mcmcout.model.d; end
if isfield(mcmcout.model,'par') if isfield(mcmcout.model.par,'indexar')  mix.par.indexar=mcmcout.model.par.indexar; end; end

if ~isstruct(mcmcout.par) 
    mix.par=mcmcout.par(m,:);
else 
    if isfield(mcmcout.par,'beta') 
        if size(mcmcout.par.beta(m,:,:),3) == 1
            mix.par.beta = squeeze(mcmcout.par.beta(m,:,:))';  
        elseif size(mcmcout.par.beta(m,:,:),2) > 1
            mix.par.beta = squeeze(mcmcout.par.beta(m,:,:));
        else    
            mix.par.beta = squeeze(mcmcout.par.beta(m,:,:))';    
        end
    end
     
    if isfield(mcmcout.par,'sigma')
         mix.par.sigma=mcmcout.par.sigma(m,:);  
    end
end
        
if mcmcout.model.K>1
    if ~mcmcout.model.indicfix
         if mcmcout.model.indicmod.dist(1:6)=='Multin'
                mix.weight=mcmcout.weight(m,:);
                
         % modified by: Olivia Bluder Sept 21, 2010    
         elseif isfield(mcmcout.model,'MOE')
            if mcmcout.model.indicmod.dist(1:6)=='FixedW'
                mix.weight = mcmcout.weight;
            else
                disp('MOE with non-fixed weights not implemented yet')
            end
         % end modification
        end
    end
end

    