%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function [ic,varargout]=mcmcic_MOE(data,mcmcout)     
% Compute information from MCMC draws for a finite mixture model 

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data

%  maximum of the mixture likelihood 
   
mix=mcmcout.model;

% modify by plankensteiner begin
 if mix.dist(1:6)~='Normal'
    warn('Function only implemented for normal distributions.'); return
 end     
    
if ~isfield(mix, 'd')
    warn('Function only implemented linear regression and MoE models.') ; return
end     
    
% modify by plankensteiner end

if ~isfield(mix,'K') mix.K=1; end

if ~isfield(mcmcout,'em')  
    [logm is]=sort(mcmcout.log.mixlik);  % approximate ML estimator
    loglikmax=logm(end);
    mldraw=is(end);
    if mix.K>1     entropy_ml=mcmcout.entropy(mldraw);  end
    
else       % use the result from the EM algorithm
    loglikmax=mcmcout.em.loglikmax;
    if mix.K>1   entropy_ml=mcmcout.em.entropy;   end
end  
ic.loglikmax=loglikmax;

[logpm is]=sort(mcmcout.log.mixlik+mcmcout.log.mixprior);  % approximate posterior mode estimator
pmdraw=is(end);
if mix.K>1     entropy_pm=mcmcout.entropy(pmdraw);  end

% loglikpm=logpm(end);  % log posterior density
loglikpm=mcmcout.log.mixlik(pmdraw);  % log likelihood



%%%%%%%%%%%  number of parameters  
%%%  
dk=0;


%%  Model for the indicator
if mix.K>1
    if  ~isfield(mix,'indicmod')   mix.indicmod.dist='Multinomial';   end

    if ~isfield(mix,'indicfix')
        % Modified by: Olivia Bluder Oct. 25, 2010 
        if or(mix.indicmod.dist(1:6)=='Multin', mix.indicmod.dist(1:6)=='FixedW')
        % end modifiation
            dk=mix.K-1;            
        end
    end
end

    dk=dk+mix.K*(mix.d+1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ic.loglikmax=loglikmax;
ic.aic= -2*loglikmax+2*dk;
ic.bic= -2*loglikmax+log(data.N)*dk;
ic.bicpm= -2*loglikpm+log(data.N)*dk;
ic.bicmc=-2*mean(mcmcout.log.mixlik)+dk*(log(data.N)-1);

if mix.K>1
    ic.iclbic_ml= ic.bic+2*entropy_ml;
    ic.iclbic_pm= ic.bicpm+2*entropy_pm;
else
    ic.iclbic_ml= ic.bic;
    ic.iclbic_pm= ic.bicpm;

end
ic.awe=ic.iclbic_ml+(3/2+log(data.N))*dk;
ic.d=dk;

mcmcout.ic=ic;
if nargout==2
    varargout{1}=mcmcout;
end    