%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function mcmcout=mcmcpermute_MOE(mcmcout, varargin)

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

if ~isfield(mcmcout.model,'indicmod')
    indicmod.dist='Multinomial';
else
    indicmod.dist=mcmcout.model.indicmod.dist;
end

estpm=mcmcpm_MOE(mcmcout);
indexp=[1:mcmcout.M];

parclust=mcmcout.par.beta;
parclust=permute(parclust,[3 1 2]); %permute such that first index is equal to group, second index to MCMC iteratio, third index to the components of group specific parameter
parclust=reshape(parclust,size(parclust,1)*size(parclust,2),size(parclust,3));
clustart=[estpm.par.beta'];

[S,clu]=kmeans(parclust,mcmcout.model.K,'start',clustart,'EmptyAction','singleton');
clear parclust;
mcmcout.perm=reshape(S,mcmcout.model.K,size(S,1)/mcmcout.model.K)'; % reshape M times K

% not sufficient
% mcmcout.isperm=(sum(mcmcout.perm,2)==(mcmcout.model.K*(mcmcout.model.K+1)/2)); % check if permutation, M times 1
mcmcout.isperm=all(sort(mcmcout.perm,2)==repmat([1:mcmcout.model.K],mcmcout.M,1),2);

mcmcout.nonperm=sum(~mcmcout.isperm); % number of draws that may not be permuted uniquely

indexperm=indexp(mcmcout.isperm);  % consider only permuted draws
if size(indexperm,2)>1
    % Modified by: Olivia Bluder Sept 21, 2010
    mcmcsub=mcmcsubseq_MOE(mcmcout,indexperm);
    % end modification

    mcmcout.parperm=mcmcsub.par;
    % Modified by: Olivia Bluder Sept 21, 2010
    if or(indicmod.dist(1:6)=='Multin',indicmod.dist(1:6)=='FixedW')
    % end modification
        mcmcout.weightperm=mcmcsub.weight;
    end

     if isfield(mcmcout.model,'d') d=mcmcout.model.d; else  d=1; end
     
    df=0;
    Mperm=mcmcout.M-mcmcout.nonperm;
    mcmcout.Mperm=Mperm;

    for k=1:mcmcout.model.K

        ik=(mcmcout.perm(indexperm,:)==k*ones(Mperm,mcmcout.model.K,1));

        if indicmod.dist(1:6)=='Multin'

            mcmcout.weightperm(:,k)=sum(ik.*mcmcsub.weight,2);
            
         % modified by: Olivia Bluder Sept 21, 2010    
         elseif isfield(mcmcout.model,'MOE')
            if mcmcout.model.indicmod.dist(1:6)=='FixedW'
                mcmcout.weightperm = mcmcsub.weight;
            else
                disp('MOE with non-fixed weights not implemented yet')
            end
         % end modification
        end
        
        mcmcout.parperm.sigma(:,k)=sum(ik.*mcmcsub.par.sigma,2);
        
        ikr(:,1,:)=ik; clear ik;
        mcmcout.parperm.beta(:,:,k)=sum(repmat(ikr,[1 (d-df) 1]).*mcmcsub.par.beta,3);
    end
    
    %modified by plankensteiner - is needed for Rsquare mixture
    if nargin==2
        mcmcout.subperm=mcmcsub;
        mcmcout.subperm.loglikMixPERM= mcmcout.log.mixlik(indexperm);
    end
    %end modification;

else
    mcmcout.Mperm=0;
    warn('Not a single draw is a permutation in the function mcmcpermute');
end

