%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function varargout=mcmcplot_MOE(mcmcout,varargin)

% Monitoring of the unidentified MCMC draws   

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data
   
if nargin==1
    ifig=1;
else
    ifig=fix(varargin{1});
end    
cl='k'; 

%begin modify by plankensteiner
if  mcmcout.model.dist(1:6)~='Normal'
 warn('Function only implemented for mixtures of normal distributions.'); return
end

if  ~isfield(mcmcout.model,'d')
 warn('Function only implemented for linear regression and MoE models.'); return
end
%end modification

if ~isfield(mcmcout.model,'indicfix') mcmcout.model.indicfix=false; end
if ~isfield(mcmcout.model,'K') mcmcout.model.K=1; end
if ~isfield(mcmcout,'ranperm') mcmcout.ranperm=false; end

if and(mcmcout.ranperm,~isfield(mcmcout,'parperm'))
% identify the model before plotting

% Modified by: Olivia Bluder Sept 21, 2010 
 mcmcout=mcmcpermute_MOE(mcmcout);
% end modification
end
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure(ifig);
  
if isfield(mcmcout.model,'K')   K=mcmcout.model.K; else      K=1;   end    

nr=1+(K>1);

subplot(nr,3,1);plot(mcmcout.log.mixlik,'k');ylabel('Mixture Likelihood')
set(gca,'xlim',[-20 mcmcout.M]);

if isfield(mcmcout,'name') title(['Posterior draws for ' mcmcout.name]);end


subplot(nr,3,2);plot(mcmcout.log.mixprior,'k');ylabel('Mixture Prior')
set(gca,'xlim',[-20 mcmcout.M]);
subplot(nr,3,3);plot(mcmcout.log.mixlik+mcmcout.log.mixprior,'k');ylabel('Mixture Posterior')
set(gca,'xlim',[-20 mcmcout.M]);

if and(K>1,~mcmcout.model.indicfix)
    
    subplot(nr,3,4);plot(mcmcout.log.cdpost,'k');ylabel('Complete Data Posterior')
    set(gca,'xlim',[-20 mcmcout.M]);
    subplot(nr,3,5);plot(mcmcout.entropy,'k');ylabel('Entropy')
    set(gca,'xlim',[-20 mcmcout.M]);
    
end

if ~isfield(mcmcout.model,'indicmod') mcmcout.model.indicmod.dist='Multinomial';  end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  compute implied moments

 margmom.empty=true; 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  plot MCMC

    if isfield(margmom,'mean')
        ifig=ifig+1;figure(ifig);
        
        subplot(3,2,1);plot(margmom.R,'k');ylabel('R');
        subplot(3,2,2);plot(margmom.mean,'k');ylabel('mean');
        subplot(3,2,3);plot(margmom.var,'k');ylabel('var');
        subplot(3,2,4);plot(margmom.skewness,'k');ylabel('skewness');
        subplot(3,2,5);plot(margmom.kurtosis,'k');ylabel('kurtosis');
    end
    
    if or(~mcmcout.ranperm,mcmcout.model.K==1)
        if isfield(mcmcout.par,'mu')
            ifig=ifig+1;figure(ifig);
            plot(mcmcout.par.mu);
            legend([repmat('k=',K,1) num2str([1:K]')]);
            if skew
               title(['Posterior draws for  \xi_k']);
            else
                title(['Posterior draws for  \mu_k']);
            end
        end
        
        if isfield(mcmcout.par,'sigma')
            ifig=ifig+1;figure(ifig);
            plot(mcmcout.par.sigma);
            legend([repmat('k=',K,1) num2str([1:K]')]);
            title(['Posterior draws for  \sigma^2_k']);
        end       
    elseif isfield(mcmcout,'parperm')
        if isfield(mcmcout.parperm,'mu')
            ifig=ifig+1;figure(ifig);
            plot(mcmcout.parperm.mu);
            legend([repmat('k=',K,1) num2str([1:K]')]);
            if skew
                title(['Posterior draws for  \xi_k']);
            else
                title(['Posterior draws for  \mu_k']);
            end
 
        end
        if isfield(mcmcout.parperm,'sigma')
            ifig=ifig+1;figure(ifig);
            plot(mcmcout.parperm.sigma);
            legend([repmat('k=',K,1) num2str([1:K]')]);
            title(['Posterior draws for  \sigma^2_k']);
        end
    end
  
    if or(~mcmcout.ranperm,isfield(mcmcout,'parperm')) 
    
    indexar=0;           
    ireg=0; iar=0;
        for j=1:size(mcmcout.par.beta,2)
            ifig=ifig+1;figure(ifig);
            if isfield(mcmcout,'parperm')
              plot(squeeze(mcmcout.parperm.beta(:,j,:)));
            elseif ~mcmcout.ranperm
              plot(squeeze(mcmcout.par.beta(:,j,:)));
            end
            legend([repmat('k=',K,1) num2str([1:K]')]);
            ireg=ireg+1;
            if mcmcout.model.d>1
            title(['Posterior draws of switching regression parameter  \beta_{k,' num2str(ireg) '}']);
            else
                title(['Posterior draws of switching intercept']);
            end
        end
    else
        warn(['The fitted model is not supported by function mixtureplot']);
    end

ifig=mcmcsamrep_MoE(mcmcout,ifig+1);

if nargout==1
    varargout{1}=ifig;
end    
