%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function varargout=mcmcpreddens_MOE(data,mcmcout,varargin)
% plots and computes the posterior predictive density  
% if data are existing, empirical as well as predicted pdf and cdf are
% plotted. 
% If data just contains data.X, the predicted pdf and cdf is plottet.
              
% modiefied such that method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

% data are handled as data stored by row  
if isfield(data,'y')            
% the field 'y' is not obligatory anymore => possible predictions for future tests 
    ibycolumn=isfield(data,'bycolumn');
    if ibycolumn  ibycolumn=data.bycolumn; end  % ibycolumn true: data stored by column 
    if ibycolumn      y=data.y'; else     y=data.y; end  
    if isfield(data,'N') N=data.N;else N=size(y,2); end
elseif ~isfield(data,'r')
    %modified by plankensteiner 
   data.r=1;
   % modification end
end      
  
if isfield(data,'r') r=data.r;else r=size(y,1); end
%modified by Plankensteiner begin
if r~=1
   warning('Function is not implemented for the multidimensional case.'); return
end

if ~isfield(mcmcout.model, 'd')
    warning('Function is not implemented for non regression.'); return
end

if ~isfield(mcmcout.model, 'MOE')
    MOE= false;
else
    MOE= mcmcout.model.MOE;
end

if mcmcout.model.dist(1:6)~='Normal'
    warning('Function is only implemented for mixtures of normal distributions.'); return
end
 
%modified by Plankensteiner end

% Modified by: Olivia Bluder Oct. 25, 2010
if nargin==2 
    nfig=1;   
else
    nfig=fix(varargin{1});
    if isempty(nfig)
        nfig=1;
    end
end

if nargin<=3
    visualize = true;
elseif varargin{2}==1
    visualize = true;
else
    visualize = false;
end
% end modification

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% loop over features, plot predictive density and compute the grid
 
if ~isfield(data,'X')
    
    % modified by Plankensteiner
    warn('Function is only implemented for an existing matrix .X. Specify matrix .X.')
    % End modification
     
% Modified  by: Olivia Bluder Sept. 30, 2010     
else
% prediction for regression models
    if visualize 
        figure(nfig)
    end
    
    disc=false(r,1);  
        if visualize 
            [nr, nc]=plotsub(r); 
            subplot(nr,nc,1);       
        end
        
        nbin=10; 
        M=10000;  % number of grid points

        if ~isfield(data,'y')
              x=zeros(1,M);
              x_min = min(min(mcmcout.est.ident.par.beta'*data.X))-3*max(mcmcout.est.ident.par.sigma);
              x_max = max(max(mcmcout.est.ident.par.beta'*data.X))+3*max(mcmcout.est.ident.par.sigma);
              x(1,:)=linspace(x_min,x_max,M);
        else
             if visualize
                  histneu(y(1,:)',nbin,'k'); 
             end   
             x=zeros(size(data.y,1),M);
             x(1,:)=linspace(min(data.y(1,:),[],2)-0.25*abs(min(data.y(1,:),[],2)),...
                             max(data.y(1,:),[],2)+0.25*abs(max(data.y(1,:),[],2)),M);
        end 
    
    if isfield(mcmcout.model,'K')
        if all([mcmcout.model.K>1,mcmcout.ranperm,~isfield(mcmcout,'parperm')])
             mcmcout=mcmcpermute_MOE(mcmcout);
        end
        if mcmcout.ranperm 
            Ncyc = mcmcout.Mperm;
        else
            Ncyc = mcmcout.M;
        end
    else
        mcmcout.model.K = 1;
        mcmcout.model.weight = 1;
        Ncyc = mcmcout.M;
    end 
          
        pred = zeros(size(x)); 
        for m=1:Ncyc
            mix=mcmcextract_MOE(mcmcout,m);
            mix.par.mu = mix.par.beta'*data.X;  
                   
            if mix.indicmod.dist(1:6)=='FixedW'
                mix.weight = eval([data.weightfun,'(data.Xweights, mix.K)']);
                mix.weight = mix.weight(1,:);  
                [sorted, ind]=sort(mix.par.mu(:,1));
                if sorted(1)<0
                    warning(['!! Mean is negative !!'])
                end
                mix.weight=mix.weight(ind);                 
            end
            pred=pred+mixturepdf_MOE(mix,x);
        end     
        pred=pred/Ncyc;
        PredDens.dens.y = x;
        PredDens.dens.pdf = pred;
            
        pred1 = zeros(Ncyc,1);     
        if mix.indicmod.dist(1:6)=='FixedW'
            mix.weight = eval([data.weightfun,'(data.Xweights, mix.K)']);
            weight=mix.weight; 
        end  
             
        if ~isfield(mcmcout, 'ranperm')
            mcmcout.ranperm=false;
        end
              
        if mcmcout.ranperm
           beta = mcmcout.parperm.beta;
           sigma = mcmcout.parperm.sigma;
           if all([mcmcout.model.K>1 ~MOE])
            weight=  mcmcout.weightperm;
           end
        else
           if ~isfield(mcmcout, 'par')
             beta = mcmcout.beta; 
             sigma = mcmcout.sigma;
           else
             beta = mcmcout.par.beta; 
             sigma = mcmcout.par.sigma;
           end 
           if all([mcmcout.model.K>1  ~MOE])
             weight = mcmcout.weight;
           end
        end    
              
        matrixmu = zeros(size(beta,1),mcmcout.model.K);
        for k=1:mcmcout.model.K
            matrixmu(:,k)=beta(:,:,k)*data.X(:,1);
        end
            
        if mcmcout.model.K>1
            [matrixmu,index_matrixmu]=sort(matrixmu,2);
            sigma = sigma(:,index_matrixmu(1,:));
            if ~MOE
            weight= weight(:,index_matrixmu(1,:));
            end
        end
         
         if mcmcout.model.K==1 
            crit=ones(Ncyc,1);
         elseif mcmcout.model.K==2  
            crit =binornd(1,weight(1),Ncyc,1);
            crit(:,2)=1-crit(:,1);    
         else   
           crit=weight; 
         end
         
        for k=1:(mcmcout.model.K) 
            pred1=pred1+crit(:,k).*normrnd(matrixmu(:,k),sqrt(sigma(:,k)));
        end 
           
        PredDens.PredDist = pred1;
        PredDens.summary = [mean(PredDens.PredDist),std(PredDens.PredDist),...
                           quantile(PredDens.PredDist,[0.025, 0.05, 0.5,0.95,0.975])];
        PredDens.colnames_summary = {'mean', 'st.dev', '0.025','0.05', '0.5','0.95','0.975'};
        if ~isfield(data,'y')
            rank = ((1:16)-0.3)/(16+0.4);
            PredDens.Pred = quantile(PredDens.PredDist,rank);
        else
            rank = ((1:length(data.y))-0.3)/(length(data.y)+0.4);
            PredDens.Pred = quantile(PredDens.PredDist,rank);
            if isfield(data,'censor')
               if any(data.censor)
                  cen_value = data.y(find(data.censor,1));
                  PredDens.Predcen = PredDens.Pred;
                  PredDens.Predcen(PredDens.Predcen>cen_value)=cen_value;
                  PredDens.res = sort(data.y)-PredDens.Predcen;
               else
                  PredDens.res = sort(data.y)-PredDens.Pred;
               end
            else
               PredDens.res = sort(data.y)-PredDens.Pred;
               data.censor=zeros(size(data.y));
            end
            PredDens.Res_st_dev =std(PredDens.res);
        end
        
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%         
end
        
        % plot predicitve density
        if visualize 
            subplot(1,2,1) 
            hold all;
            if disc(1)     
                bar(x,pred(1,:),0.3);     
                set(gca,'xlim',[x(1,1)-1 x(1,end)+1]);
            else
                plot(x(1,:),pred(1,:),'--r'); 
                if ~isfield(data,'y') 
                    legend('pred. density','Location','North');
                else   
                    if sum(data.censor)~=data.N
                        ksdensity(data.y, 'cens',data.censor)
                        legend('pred. density','ksdensity(data)','Location','North');
                    end
                end
            end
            
            xlabel(['y']);

            if isfield(data,'name')
                 title(['Posterior predictive density of the ' char(data.name) ' data']);
            else
                title(['Posterior predictive density']);
            end
            hold off;  
            subplot(1,2,2)
            normalizing = sum(pred);
            plot(x, cumsum(pred)/normalizing,'--r');
            hold on
            if ~isfield(data,'y')
                hold off
                legend('pred. cdf','Location','East');
            else 
                cdfplot(data.y); 
                hold off
                % modified plankensteiner begin
                legend('pred. cdf', 'emp. cdf','Location','East');
                % modified plankensteiner end
                if isfield(data,'name') 
                    title(['Posterior predictive cumulative distribution of the ' char(data.name) ' data']); 
                else
                    title(['Posterior predictive cumulative distribution']); 
                end
            end  
            xlabel(['y']);
        end   
% end modification 

%begin modification plankensteiner
legend('pred. cdf', 'emp. cdf','Location','East');
 
if isfield(PredDens, 'res')
    PredDens.SSE=sum(PredDens.res.^2);
end
%end modification

if nargout==1 varargout{1}=nfig; end

if nargout==2
    varargout{1}=nfig;
    varargout{2}=PredDens;
end
 

