%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function varargout=mcmcsamrep_MOE(mcmcout,varargin)
% Sampling representation of the MCMC draws mcmcout

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data 


if nargin==1
    ifig=1;
    data.empty=true;
elseif nargin==2
    if ~isstruct(varargin{1})
        ifig=fix(varargin{1});
        data.empty=true;
    else 
        data=varargin{1};ifig=1;
    end
elseif nargin==3
    data=varargin{1};
    ifig=fix(varargin{2});
end    
sizep=2;cp='ko';%
cp='rx';% cp='go';

if ~isfield(mcmcout.model,'K') mcmcout.model.K=1; end
 finmix=all([~isfield(mcmcout.model,'d') ~isfield(mcmcout.model,'ar') ~isfield(mcmcout.model,'arf')]);

indexscatter=fix(linspace(1,mcmcout.M,min(2000,mcmcout.M)));
 
if ~finmix  % mixture regression models 
    
    %%% point process for each pair of regression parameters
    
    ifig=ifig+1;    figure(ifig); 
    if ~isfield(mcmcout.model,'indexdf')
        
        mcmcout.model.df=0;
    else
        mcmcout.model.df=prod(size(mcmcout.model.indexdf));
    end
    if (mcmcout.model.d-mcmcout.model.df)>1
        ij=nchoosek([1:(mcmcout.model.d-mcmcout.model.df)]',2);
        [nr, nc]=plotsub(size(ij,1));
    else
        ij=1; nr=1; nc=1;
        
    end
    
    for ii=1:size(ij,1)
        if ii==1  title(['Point process representation -- K=' num2str(mcmcout.model.K)]);  end
        subplot(nr,nc,ii);  
        for j=1:mcmcout.model.K
            if (mcmcout.model.d-mcmcout.model.df)>1
                scatter(mcmcout.par.beta(indexscatter,ij(ii,1),j),mcmcout.par.beta(indexscatter,ij(ii,2),j),sizep,cp);hold on;
                ylabel(['\beta_{.,' num2str(ij(ii,2)) '}']);
            else
                scatter(mcmcout.par.beta(indexscatter,ij(ii,1),j),randn(1,size(indexscatter,2)),sizep,cp);hold on;
                ylabel('standard normal');
            end
        end
        xlabel(['\beta_{.,' num2str(ij(ii,1)) '}']);
    end
    
     if all(mcmcout.model.dist(1:6)=='Normal')
        ifig=ifig+1;    figure(ifig); 
        for k=1:mcmcout.model.K   scatter(mcmcout.par.sigma(indexscatter,k),randn(1,size(indexscatter,2)),sizep,cp); hold on;end
        ylabel('standard normal');
        %for k=1:mcmcout.model.K   scatter(mcmcout.par.sigma(indexscatter,k),mcmcout.Nk(indexscatter,k),sizep,cp); hold on;end
        %ylabel('group size');
        xlabel('\sigma^2');
        title(['Point process representation for the variance -- K=' num2str(mcmcout.model.K)]); 
    end
    
    if ~isfield(data,'empty') 
        
        ifig=ifig+1;    figure(ifig); 
        
        [xmin imin]=min(data.X,[],2);
        [xmax imax]=max(data.X,[],2);
        [nr, nc]=plotsub(mcmcout.model.d-1);
        
        for k=1:mcmcout.model.K 
            isub=0;
            for ij=1:mcmcout.model.d
                %Xdes=[data.X(:,imin(ij)) data.X(:,imax(ij))];
                Xdes=data.X;
                if (xmin(ij)-xmax(ij))~=0
                    isub=isub+1;
                    subplot(nr,nc,isub);
                    if k==1 scatter(data.X(ij,:),data.y);  hold on; end
                    
                    if mcmcout.model.df>0
                        intercept=[1:mcmcout.model.d];
                        indexdr=intercept(all(repmat(mcmcout.model.indexdf,1,mcmcout.model.d)~=repmat(intercept,mcmcout.model.df,1),1));
                        mu=Xdes(indexdr,:)'*mcmcout.par.beta(indexscatter,:,k)';
                        mu=mu+ Xdes(mcmcout.model.indexdf,:)'*mcmcout.par.alpha(indexscatter,:)';
                    else    
                        mu=Xdes'*mcmcout.par.beta(indexscatter,:,k)';
                    end
                    %if mcmcout.model.dist(1:6)=='Poisso'  mu=exp(mu); end
                    [Xdes,is]=sort(Xdes(ij,:));
                    scatter(Xdes,mean(mu(is,:)',1),'r');
                    
                    %plot(Xdes(ij,[imin(ij) imax(ij)]),mu([imin(ij) imax(ij)],:)','g');
                    xlabel(['x' num2str(ij)]);
                end
            end
        end
    end

else
    ['Point representation of simulated mixture models through mcmcsamrep not supported for mixtures of type ' mcmcout.model.dist]
end  


if nargout==1
    varargout{1}=ifig;
end    
