%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function [data,mix,mcmc]=mcmcstart_MOE(data,mix,varargin);
% determines starting value for MCMC estimation
 
% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

% Modified by Plankensteiner begin
%% check first if model is a regression model.

if ~isfield(mix, 'd')
    warn('Function is only implemented for regression models.'); return
end

% check if data is stored as column
s=size(data.y); 
if min(size(data.y))~=s(1)
   data.y=data.y' 
end

% Modified by Plankensteiner end

if nargin==2  % default choice for mcmc 
    mcmc.startpar=false;
else
    mcmc=varargin{1}; 
end 


if ~isfield(data,'N') N=size(data.y,2); data.N=N; else N=data.N;end
if ~isfield(mcmc,'M')         mcmc.M=5000;         end
if ~isfield(mcmc,'burnin')    mcmc.burnin=1000;    end
if ~isfield(mcmc,'storeS')    mcmc.storeS=500;     end
if ~isfield(mcmc,'storepost') mcmc.storepost=true; end
if ~isfield(mcmc,'startpar')  mcmc.startpar=false; end
if ~isfield(mcmc,'ranperm')   mcmc.ranperm=true; end   

if ~isfield(mix,'K') K=1; mix.K=1; else K=mix.K; end

norstud=any(all(mix.dist(1:6)=='Normal'));

if ~norstud
 ['Function for ' mix.dist 'not implemented.']; return
end

if ~isfield(mix,'r') 
    if isfield(data,'r') 
        mix.r=data.r;  
    else
        mix.r=prod(size(data.y))/data.N;
    end; 
end  %
  
% begin modification Plankensteiner 
if mix.r >1
   warn(['Function is not implemented for data.r ' mix.r]); 
   return;
end 
% modification end

if K>1
    if ~isfield(mix,'indicmod')  mix.indicmod.dist='Multinomial'; end
    if and(mcmc.startpar,~isfield(mix,'weight')) mix.weight=ones(1,mix.K)/mix.K; end
end

if mcmc.startpar

%% Starting values for regression models
    
        mixreg=mix; 
        datareg=data;

        if ~isfield(mixreg,'indexdf')
            mixreg.df=0;
        else
            mixreg.df=size(mixreg.indexdf,1)*size(mixreg.indexdf,2);
        end
        if  mixreg.df>0
            startalpha=false;
            if ~isfield(mix,'par')  startalpha=true;   elseif ~isfield(mix.par,'alpha')   startalpha=true;  end
            if startalpha   mix.par.alpha=zeros(mixreg.df,1);  end
        end

        startbeta=false;
        if ~isfield(mix,'par')  startbeta=true;  elseif ~isfield(mix.par,'beta') startbeta=true;  end

        if startbeta
            mix.par.beta=zeros(mixreg.d-mixreg.df,K);
            if isfield(datareg,'X')
                index=[1:size(datareg.X,1)];
                intercept=sum(index(all(diff(datareg.X,[],2)==0,2))); % determine the index of the intercept
                if mixreg.df>0 intercept=intercept-sum(mixreg.indexdf<intercept); end;
            else
                intercept=1;
            end

            if K==1
                mix.par.beta(intercept,:)=mean(data.y);
            else
                mix.par.beta(intercept,:)=mean(data.y)+std(data.y)*randn(1,mix.K);
            end
        end

        if ~isfield(mix.par,'sigma')  mix.par.sigma=repmat(std(data.y),1,K);  end
else  

%% start with a classification
        if  and(~isfield(data,'S'),K>1)
            if mix.d>1
                [Skm,mukm]=kmeans([data.y;data.X]',K, 'EmptyAction','singleton');
            else
                [Skm,mukm]=kmeans(data.y',K, 'EmptyAction','singleton');
            end
            data.S=Skm';
        end
        
        startsigma=true; if isfield(mix,'par') if isfield(mix.par,'sigma') startsigma=false; end; end
        if startsigma  mix.par.sigma=repmat(std(data.y),1,K);  end
end