%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function mcmcsub=mcmcsubseq_MOE(mcmcout,mall);
% stores the m-th MCMC draw as mixture model
 
% Modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data
if size(mall,1)*size(mall,2)==1
     
    warn(['Use the Subroutine MCMCEXTRACT to extract a single mixture'])
    mcmcsub=[];return
end

% modify by plankenstener begin
if mcmcout.model.dist(1:6)~='Normal'
   warn('This Function is only implemented for mixture of normal distributions.'); return
end

if ~isfield(mcmcout.model, 'd')
   warn('This Function is only implemented for linear regression and MoE models.'); return
end
% modify by plankensteiner end

if size(mall,2)==1  mall=mall'; end 

mcmcsub.model=mcmcout.model;
mcmcsub.prior=mcmcout.prior;
if isfield(mcmcout,'clust') mcmcsub.clust=mcmcout.clust; end

if ~isfield(mcmcout.model,'indicfix')  mcmcout.model.indicfix=false; end
if ~isfield(mcmcout.model,'indicmod') mcmcout.model.indicmod.dist='Multinomial';  end


if ~isfield(mcmcout.model,'K')   mcmcout.model.K=1; end

if all([~mcmcout.model.indicfix mcmcout.model.K>1 isfield(mcmcout,'S')])
    MS=mcmcout.M-size(mcmcout.S,1);
    mallS=mall(mall>MS)-MS;
    mcmcsub.S=mcmcout.S(mallS,:);
end

mcmcsub.M=size(mall,2);
if isfield(mcmcout,'ranperm')  mcmcsub.ranperm= mcmcout.ranperm; end

mcmcsub.log.mixlik=mcmcout.log.mixlik(mall);
mcmcsub.log.mixprior=mcmcout.log.mixprior(mall);

if and(mcmcout.model.K>1,~mcmcout.model.indicfix)
    mcmcsub.entropy=mcmcout.entropy(mall);
    mcmcsub.log.cdpost=mcmcout.log.cdpost(mall);
    if mcmcout.model.indicmod.dist(1:6)=='Multin' 
        mcmcsub.weight=mcmcout.weight(mall,:);
        if isfield(mcmcout,'post')  mcmcsub.post.weight = mcmcout.post.weight(mall,:); end
        
    % Modified by: Olivia Bluder Sept 21, 2010    
    elseif isfield(mcmcout.model,'MOE')
        if mcmcout.model.indicmod.dist(1:6)=='FixedW' 
            mcmcsub.weight=mcmcout.weight;
        else
            disp('MOE with non-fixed weights not implemented yet') 
        end
    % end modification
    end
end

if ~isstruct(mcmcout.par) 
    mcmcsub.par=mcmcout.par(mall,:);
else
    if isfield(mcmcout.par,'beta') 
        mcmcsub.par.beta= mcmcout.par.beta(mall,:,:);
    end
        
    if isfield(mcmcout.par,'sigma')
            mcmcsub.par.sigma=mcmcout.par.sigma(mall,:);
    end
end

if isfield(mcmcout,'Nk') mcmcsub.Nk=mcmcout.Nk(mall,:); end
if isfield(mcmcout,'hyper') mcmcsub.hyper=mcmcout.hyper(mall,:); end

if isfield(mcmcout,'post')
    
    if ~isstruct(mcmcout.post.par)
        mcmcsub.post.par=mcmcout.post.par(mall,:,:);
    else        
        if isfield(mcmcout.post.par,'sigma') 
                mcmcsub.post.par.sigma.c=mcmcout.post.par.sigma.c(mall,:);
                mcmcsub.post.par.sigma.C=mcmcout.post.par.sigma.C(mall,:); 
        end   
        
        if isfield(mcmcout.post.par,'beta') 
            mcmcsub.post.par.beta.b=mcmcout.post.par.beta.b(mall,:,:);
            mcmcsub.post.par.beta.B=mcmcout.post.par.beta.B(mall,:,:,:);
        end  
    end
end