%	 Copyright (C) 2006  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function fd=mixnorprior_MOE(mix,prior,varargin)

% Evaluates the prior of a univaraite or multivariate normal mixture model at the parameter values
% stored in mix

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data

if nargin==2  % check variables
    if ~isfield(mix,'r') 
            mix.r=1; 
    end
    
    if ~isfield(mix,'K') mix.K=1; end
    
    if and(isfield(mix.par,'sigmainv'),isfield(mix.par,'sigma'))
        if mix.r==1
            if any((mix.par.sigma*mix.par.sigmainv)~=ones(1,K))  warn(['discrepancy in the fields sigma and sigmainv in the definition of the mixture model when evaluating the prior']);fd=[];return;end
        elseif mix.r>1
            for k=1:mix.K
                if any(any(abs((mix.par.sigma(:,:,k)*mix.par.sigmainv(:,:,k)-eye(mix.r))./mix.par.sigma(:,:,k))>10^(-3)))
                    warn(['discrepancy in the fields sigma and sigmainv in the definition of the mixture model when evaluating the prior']);fd=[];
                end
            end
        end
    elseif  mix.r>1 
        if ~isfield(mix.par,'sigmainv') 
            mix.par.sigmainv=zeros(size(mix.par.sigma));
            for k=1:mix.K; 
                mix.par.sigmainv(:,:,k)=inv(mix.par.sigma(:,:,k)); 
            end
        end
        if ~isfield(mix.par,'logdet') 
            for k=1:mix.K; 
                mix.par.logdet(1,k)=log(det(mix.par.sigmainv(:,:,k)));  
            end    
        end
    end
end

r=mix.r; K=mix.K;
   
fd=0;

if r==1
        if ~isfield(mix,'df')  mix.df=0; end
            if size(mix.par.beta,1)==1
                fd=fd+prodnormultpdflog(struct('mu',prior.par.beta.b,'sigmainv',squeeze(prior.par.beta.Binv)'),mix.par.beta);
            else    
                fd=fd+prodnormultpdflog(struct('mu',prior.par.beta.b,'sigmainv',prior.par.beta.Binv),mix.par.beta);
            end    
        if mix.df>0
                
            fd=fd+prodnormultpdflog(struct('mu',prior.par.alpha.a,'sigmainv',prior.par.alpha.Ainv),mix.par.alpha);
        end
        

    %  add hierarchical prior
    hier_prior=isfield(prior,'hier');if hier_prior hier_prior=prior.hier;end   
    if hier_prior
        gN=prior.par.sigma.g+sum(prior.par.sigma.c,2);
            GN=prior.par.sigma.G+sum(1./mix.par.sigma,2);
        Cstar=gN/GN;
        prior.par.sigma.C=repmat(Cstar,1,K);
        % use candidates formula to compute 
        fd=fd+ prodgampdflog(struct('a',prior.par.sigma.g,'b',prior.par.sigma.G),Cstar)-prodgampdflog(struct('a',gN,'b',GN),Cstar);
    end    
   
    % add prior sigma 
       % if all(prior.type(1:4)=='sigm')
      %      fd=fd-mix.K*log(prior.par.sigma.max)-sum(log(mix.par.sigma));
      %      if any(mix.par.sigma.^.5>prior.par.sigma.max)  warn('Sigma greater than upper bound in function prioreval'); end
   %     else
            fd=fd+ prodinvgampdflog(struct('a',prior.par.sigma.c,'b',prior.par.sigma.C),mix.par.sigma);
    %    end

 else warn('Not implemented for multidimensional data.')
 end    

