%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function varargout=mixtureplot_MOE(mix,varargin);

% Plot the density of a finite mixture model, stored in the structure array mix 
  
if nargin==1 nfig=1; else nfig=fix(varargin{1}); end

if ~isfield(mix,'K') mix.K=1; mix.weight=1; end  % single member from the distribution family
if and(mix.K==1,~isfield(mix,'weight')) mix.weight=1; end  % single member from the distribution family

if ~isfield(mix,'indicmod') mix.indicmod.dist='Multinomial';  end
if   mix.indicmod.dist(1:6)=='Markov'  if mix.K>1 mix.weight=marstat(mix.indicmod.xi); else mix.weight=1; end;end

% modification by Plankensteiner, begin
if ~isfield(mix, 'd')
   mix.d=1; 
end
% modification by Plankensteiner end

%%   univariate mixture of normal distributions - density plot
   
if mix.dist(1:6)=='Normal'
    
    % define the grid on the x-axis    
    M=1000;  % number of grid points
      
    % modification begin, Plankensteiner
    if mix.d > 1 
        mix.par.mu=mix.par.beta*data.X;
    else
        mix.par.mu=mix.par.beta;
    end
    % modification end, Plankensteiner
      
    [ss is]=sort(mix.par.mu); %sort the means to define the domain of the plot
    c=5; % define the lower and the upper bound from the quantile    
    
    x=linspace(mix.par.mu(is(1))-c*sqrt(mix.par.sigma(is(1))),mix.par.mu(is(mix.K))+c*sqrt(mix.par.sigma(is(mix.K))),M);
    
     % modification begin, Plankensteiner
     
    pd=mixturepdf_MOE(mix,x);
     % modification end, Plankensteiner
    
    figure(nfig); 
    
    % modification begin, Plankensteiner
    plot(x,pd,'r', 'LineWidth', 2);
    % modification end, Plankensteiner
    
    %%   univariate mixture of skew normal distributions - density plot
    
else
    warn('Function is only implemented for a mixture of normal distributions!'); return
end


if nargout==1 varargout{1}=nfig; end
