%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function fd = normalpdflog_censor(par,theta,censor)
 
% computes the logarithm of univariate normal posterior density over a grid
 
% input
% par ... parameter of the aposteriori density, structrual array with the
%         fields mu and sigma; 
% theta ... argument of the  aposteriori density
% censor ... indicator if argument is censored or not (1 = censored)

%output: log of the posterior density
%        M times N array with N being the maximum number of row in par and
%        theta

if ~isfield(par,'mu') warn(['Field mu missing in function normalpdflog']);fd=[];return; end  
if ~isfield(par,'sigma') warn(['Field sigma missing in function normalpdflog']);fd=[];return; end  

if or(size(par.mu,1)~=size(par.sigma,1),size(par.mu,2)~=size(par.sigma,2)) 
     warn(['Size disagreement in the variable par in function normalpdflog']); fl=[]; return
end     

if ~(size(par.mu,2)==size(theta,2))   warn(['Size disagreement in function normalpdflog']); fl=[]; return; end

if size(par.mu,1)==1  % evaluate a single density at a sequence of draws
    
   par.mu=repmat(par.mu,size(theta,1),1);
   par.sigma=repmat(par.sigma,size(theta,1),1);
   
elseif size(theta,1)==1  % evaluate a sequence of density at a single draw
    
   theta=repmat(theta,size(par.mu,1),1);
     
elseif ~(size(par.mu,1)==size(theta,1))
    warn(['Size disagreement in function normalpdflog']); fl=[]; return
else    
%    evaluate  density in row i at the corresponding draw in row i
end
   
% Modified by: Olivia Bluder Oct. 25, 2010
fd=log(normpdf(theta, par.mu,sqrt(par.sigma))).^(1-censor).*...
   log(1-normcdf(theta, par.mu,sqrt(par.sigma))).^censor;
