%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function post=posterior_MOE(data,model,prior,varargin)

% computes the moments of the posterior distribution  under a conditionally
% conjugate  prior disribution
%
% If the procedure is used many times, for instance as part of an MCMC algorithm,  automatic check
% should be suppressed for the sake of efficiency, by calling the function with an additional argument equals
% 0, e.g.
%  post=posterior(data,model,prior,0);}

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data 

if ~isfield(model,'K')  K=1; model.K=1; end
norstud=any([model.dist(1:6)=='Normal' model.dist(1:6)=='Normul' model.dist(1:6)=='Stumul' model.dist(1:6)=='Studen']);

if ~isfield(model,'error')  % Normal or student mixture; default: switching variane
   model.error='switch';
end    
 

if nargin==3  
    % check the dimension of the data
    % data are handled as data stored by row
    if isfield(data,'bycolumn') ibycolumn=data.bycolumn; else ibycolumn=false; end  % ibycolumn true: data stored by column 
    if ibycolumn      
        data.y=data.y'; 
        if isfield(data,'X') data.X=data.X'; end
        data.bycolumn =false; 
    end  
    if ~isfield(data,'empty') data.empty=false; end
    if ~isfield(data,'N') N=size(data.y,2); data.N=N; end
    
    if and(model.K>1,~isfield(data,'S'))   
        warn(['The data have to be completely specified, including the allocations in field S']);
        post=[];return;
    end
end

if model.dist(1:6)=='Multin'
     % posterior density of the parameter of  multnomial distribution
     if data.empty     post=prior;
     else 
         post = countex(data.y,model.cat)' + prior;
     end

elseif norstud
    
    mufix=false;
    sigmafix=false;
    betafix=false;
    if isfield(model,'parfix')
        if  isfield(model.parfix,'mu')    mufix=model.parfix.mu;     end  
        if  isfield(model.parfix,'beta')    betafix=model.parfix.beta;     end  
        if  isfield(model.parfix,'sigma')  sigmafix=model.parfix.sigma;     end  
    end  
    
    if isfield(data,'r') r=data.r; else r=size(data.y,1); end
    
    
    
    if data.empty
         if or(mufix,betafix)
             post.c=prior.c;post.C=prior.C;
             if r>1    post.logdetC=prior.logdetC;    end

         elseif and(~mufix,~sigmafix)           
                post.beta.b=prior.beta.b;
                post.beta.Binv= prior.beta.Binv;
                post.beta.B= 0*post.beta.Binv;
                if  size(prior.beta.b,1)>1
                    for k=1:model.K;post.beta.B(:,:,k)=inv(squeeze(post.beta.Binv(:,:,k)));end
                else
                    post.beta.B=1./post.beta.Binv;
                end
            post.sigma.c=prior.sigma.c;post.sigma.C=prior.sigma.C;
            if r>1       post.sigma.logdetC=prior.sigma.logdetC;    end
        elseif sigmafix
            post.b=prior.b; post.Binv= prior.Binv;
            for k=1:model.K;post.B(:,:,k)=inv(squeeze(post.Binv(:,:,k)));end  
        end
        return;
        
    end 
    
    if model.K==1   % single member from the distribution family
        S=ones(1,data.N); 
    else    % mixture distribution
        S=data.S;
    end   
    ind = repmat(S,model.K,1) == repmat([1:model.K]',1,data.N);
    Nk = sum(ind,2)';
    
     if and(mufix,sigmafix)   
         warn(['It is not possible to fix both the mean and the variance in function posterior']);post=[];return;   
         
     elseif all([betafix sigmafix isfield(model,'d')])
        warn(['It is not possible to fix both the regression parameters and the variance in function posterior']);post=[];return;   
        
     elseif all([~betafix ~sigmafix isfield(model,'d')])  
        warn(['It is not possible to estimate both the regression parameters and the variance in function posterior']);post=[];return;  
        
     elseif all([isfield(model,'d') model.K==1 sigmafix model.error=='hetero'])  
         % a single multiple regression models with fixed heteroscedastic errors
        
         if ~isfield(model.par,'sigma')  warn(['A value has to be assigned to the variance before calling the function posterior for a fixed mean']);post=[];return;  end
          
         sigmainv = 1./model.par.sigma.^.5;  %squareroot
         y=(data.y.*sigmainv)';
         X=(data.X.*repmat(sigmainv,size(data.X,1),1))';
         post.B=inv(prior.Binv + X'*X);
         post.b  = post.B*(prior.Binv*prior.b + X'*y);
         
         
     elseif and(sigmafix,isfield(model,'d'))  % finite mixture of multiple regression models with fixed variance
        
        if ~isfield(model.par,'sigma')  warn(['A value has to be assigned to the variance before calling the function posterior for a fixed mean']);post=[];return;  end
          
        post.Binv = 0*prior.Binv;   post.B  = 0*prior.Binv;  post.b  = 0* prior.b;  
        sigmainv = 1./model.par.sigma;  
        for k=1:model.K 
            Xk=data.X(:,S==k)'; 
            post.Binv(:,:,k)= prior.Binv(:,:,k)+ sigmainv(k)*Xk'*Xk;
            post.B(:,:,k)=inv(post.Binv(:,:,k));
            post.b(:,k)  = post.B(:,:,k)*(squeeze(prior.Binv(:,:,k))*prior.b(:,k) + sigmainv(k)*Xk'*data.y(:,S==k)');
        end
       
     elseif betafix  % finite mixture of multiple regression models with fixed regression parameters
        
        if ~isfield(model.par,'beta') warn(['A value has to be assigned to the regression parameters before calling the function posterior for a fixed mean']);post=[];return; end
        
        post.c=prior.c + 0.5*Nk;
        if ~isfield(model,'df') model.df=0; end
        if model.df>0
            intercept=[1:model.d];
            indexdr=intercept(all(repmat(model.indexdf,1,model.d)~=repmat(intercept,model.df,1),1));
            mu=model.par.beta'*data.X(indexdr,:);
            mu=mu+repmat(model.par.alpha'*data.X(model.indexdf,:),model.K,1);
        else    
            mu=model.par.beta'*data.X;
        end

        
        error=(repmat(data.y,model.K,1)-mu).*ind;
        post.C=prior.C  + 0.5*  sum(   error.^2  ,2)';
        
     elseif all([~betafix ~sigmafix isfield(model,'d')])    % finite mixture of multiple regression models under a conjugate prior
        
        % new October  2007
%         
        post.beta.Binv = 0*prior.beta.Binv;   post.beta.B  = 0*prior.beta.Binv;  post.beta.b  = 0* prior.beta.b;  
        post.sigma.C=0*prior.sigma.C;
        for k=1:model.K
            Xk=data.X(:,S==k)'; 
            post.beta.Binv(:,:,k) = prior.beta.Binv(:,:,k) + Xk'*Xk;
            post.beta.B(:,:,k)=inv(post.beta.Binv(:,:,k));
            post.beta.b(:,k)  = post.beta.B(:,:,k)*(squeeze(prior.beta.Binv(:,:,k))*prior.beta.b(:,k) + Xk'*data.y(:,S==k)');
            yhat = (Xk*post.beta.b(:,k))';
            post.sigma.C(1,k)=prior.sigma.C(1,k)  + 0.5*sum((data.y(1,S==k)- yhat).^2 ,2)' + 0.5*(prior.beta.b(:,k)-post.beta.b(:,k))'*prior.beta.Binv(:,:,k)*(prior.beta.b(:,k)-post.beta.b(:,k));
        end
        post.sigma.c=prior.sigma.c + 0.5*Nk;
    end
else
     post.error=true; return;
 end
