%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function prior=priordefine_MOE(data,mix,varargin);
% bereinigt...
% Define a slightly informative data based prior for a finite mixture model, stored in the structure array mix

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

%% check  arguments   
if ~isfield(mix,'dist')  
    warn('The field dist is obligatory in the structure array defining the mixture when calling the function priordefine')
    prior=[];return
end  

% modefied by plankensteiner begin
if ~all(mix.dist(1:6)=='Normal')
    warn('Function is only implemented for mixtures of normal distributions.')
    prior=[];return
end
% modefied by plankensteiner end

if ~isfield(mix,'d')
    warn('Function is only implemented for regression models.')
    prior=[];return 
end 

if ~isfield(data,'r') data.r=size(data.y,1); end
if ~isfield(data,'N') N=size(data.y,2); data.N=N; else N=data.N;end
if ~isfield(mix,'K') mix.K=1;  end  % single member from the distribution family
if ~isfield(mix,'r') if isfield(data,'r')  mix.r=data.r;  else mix.r=prod(size(data))/data.N; end; end  %

% data are handled as data stored by row
ibycolumn=isfield(data,'bycolumn');
if ibycolumn  ibycolumn=data.bycolumn; end  % ibycolumn true: data stored by column
if ibycolumn      data.y=data.y'; data.bycolumn ='false'; end

if ~isfield(data,'y')
    warn('The field y is obligatory in the structure array defining the data when calling the function priordefine')
    prior=[];return 
end 
 

if ~isfield(mix,'indicmod') mix.indicmod.dist='Multinomial';  end

if all([~isfield(mix,'error') mix.dist(1:6)=='Normal']) % default: switching variance
    mix.error='switch'; 
end

    %% mixtures of normal distributions

    if nargin==2   % default prior:  independence hierarchical prior
        ihier=true; chtype='indep';
    else           %
        prior=varargin{1};
        ihier=isfield(prior,'hier');if ihier ihier=prior.hier;else ihier=true; end   % ihier true: hierarchical prior
        if isfield(prior,'type')
            chtype = prior.type;
        else % if field type is not specified or for a regression model, assume independence prior
            chtype='indep';
        end
    end
    
    prior=struct('hier',ihier,'type',chtype);

    % Modified by: Olivia Bluder Nov 2nd, 2010 
   
    if isfield(prior,'type')
        prior=struct('hier',ihier,'type',chtype);
    else
        prior=struct('hier',ihier,'type','indep');
    end
    % end modification 
    
    % modification Plankensteiner June, 2012
    if ~strcmp(prior.type,'indep')
        warn('function is not implemented for this prior.type.'); prior =[]; return;
    end   
    %end modification
       
    % data are handled as data stored by row
    ibycolumn=isfield(data,'bycolumn');
    if ibycolumn  ibycolumn=data.bycolumn; end  % ibycolumn true: data stored by column
    if ibycolumn      y=data.y'; else     y=data.y; end
    if isfield(data,'r') r=data.r;else r=size(y,1); end
    if isfield(data,'N') N=data.N;else N=size(y,2); end

    if ~isfield(mix,'d')  mix.d=1; end
    mixreg=mix; 
    datareg=data;

 

     if ~isfield(mix,'indexdf') mix.df=0; else mix.df=size(mix.indexdf,1)*size(mix.indexdf,2); end
 
     if ~isfield(mixreg,'indexdf') mixreg.df=0; else mixreg.df=size(mixreg.indexdf,1)*size(mixreg.indexdf,2); end
     
        b0=zeros(mixreg.d-mixreg.df,1);

        interceptdata=true;  %% prior of the intercept from the data
        % interceptdata=false;

        if interceptdata
            if isfield(datareg,'X')
                index=[1:size(datareg.X,1)];
                intercept=sum(index(all(diff(datareg.X,[],2)==0,2))); % determine the index of the intercept
            else
                intercept=1;
            end


            if mixreg.df>0
                if all(mixreg.indexdf~=intercept)
                    intercept=intercept-sum(mixreg.indexdf<intercept);

                    if all(mix.dist(1:6)=='Normal')
                        b0(intercept)=mean(y,2);
                    end
                end;
            end

        end



        %%%%%%%%%%%  variance of the prior of regression coefficients

        varreg=10; %% varianz of regression coefficients: 10
        %varreg=4; %% varianz of regression coefficients: 4

        varar=0.25;  %% varianz of AR coefficients: 0.1


        B0inv=eye(mixreg.d-mixreg.df)/varreg;

        prior.par.beta=struct('b',repmat(b0,1,mix.K),'Binv',repmat(B0inv,[1 1 mix.K]));


        if  mixreg.df>0

            a0=zeros(mixreg.df,1);
            A0inv=eye(mixreg.df)/varreg;

            if interceptdata
                if any(mixreg.indexdf==intercept)
                    intercept=sum(mixreg.indexdf<=intercept);
                    a0(intercept)=mean(y,2);
                end
            end
            
            prior.par.alpha=struct('a',a0,'Ainv',A0inv);
        end
 
        %%%%%%%%%%%%    prior variances

        if isfield(mix,'error')
            prQnu=2.5; %   ratio boundend by  a factor 10.
            Rhet=0.5;%    Rhet=0.9;
            chet=(1-Rhet);
            prQS=chet*var(y')*(prQnu-1);

            if  ihier
                g0=0.5;  % test:             g0=2;
                G0= g0*inv(prQS);   %match  hierarchical and non-hierarchical priors
                prior.par.sigma=struct('c',repmat(prQnu,1,mix.K),'C',repmat(prQS,1,mix.K),'g',g0,'G',G0);
            else
                prior.par.sigma=struct('c',repmat(prQnu,1,mix.K),'C',repmat(prQS,1,mix.K));
            end 
        end

%%%%%%%%%%%%%%    prior indicator model %%%%%%%%%%%%%%%%%%%%%

if mix.K>1
    % prior.K=mix.K;

    if mix.indicmod.dist(1:6)=='Multin'

        e0=4;   % prior of the weight distribtuion;
 
        prior.weight=repmat(e0,1,mix.K);

    % modified by Bluder 20.09.2010        
    elseif isfield(mix,'MOE') 
        if mix.indicmod.dist(1:6)=='FixedW' 
            if ~isfield(mix, 'weightfun') 
                disp('no weight function defined!')
            elseif ~isfield(data, 'Xweights')
                disp('Xweights values are missing')
            else  
                prior.weight = eval([mix.weightfun,'(data.Xweights, mix.K)']);
            end
        else
            disp('priors for MOE with non-fixed weights not implemented yet')
        end
    % end modification
    
    else
        ['Indicator ' mix.indicmod.dist '  not supported by function priordefine']

    end
end 