%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function logprior=prioreval_MOE(model,prior)

% Evaluates the prior of a model at the parameter values stored in model

% modified such that method can only handle regression
% models or MoE models based on univariate Gaussian data, Dec.2011

mix.dist=model.dist;

% if nor
    % changed by O. Bluder 15.09.2010
    logprior=mixnorprior_MOE(model,prior); 
    % end modification 
% else
%     warn(['Mixture type ' model.dist '  not supported by function prioreval'])
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   add the prior of the indicator model
%
if ~isfield(model,'K') model.K=1; end
if ~isfield(model,'indicmod') model.indicmod.dist='Multinomial';  end
if ~isfield(model,'indicfix') model.indicfix=false;  end

if and(model.K>1,~model.indicfix)
    
    if model.indicmod.dist(1:6)=='Multin' 
        logprior=logprior+ dirichpdflog(prior.weight,model.weight); 
       
    % modified by O. Bluder Sept. 20, 2010  
    elseif isfield(model,'MOE')
        if model.indicmod.dist(1:6)=='FixedW'
            logprior = logprior;
        else
            warn('MOE with non-fixed weights not implemented yet'); return
        end
    else 
        warn('Function only implemented for MoE models with fixed weights.'); return
    end
end
 
