%	 Copyright (C) 2006  Frhwirth-Schnatter
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function simout = prodgamsim(par,varargin)

% simulates from a product of Gamma posterior density 
 
% input
% par ... parameter of the  density, structrual array with the
%         fields a and b; 
%         the number of colums determine the  number K of products
%         for a single colum, this reduces to a single gamma density

% for two argument:  varargin determines the number of draws, otherwise it assumed that a single darw is required  

%output: simout ... simulated values  (varargin times K)  array 
 
if ~isfield(par,'a') warn(['Field a missing in function prodgamsim']);fd=[];return; end  
if ~isfield(par,'b') warn(['Field b missing in function prodgamsim']);fd=[];return; end  

if or(size(par.a,1)~=size(par.a,1),size(par.a,2)~=size(par.a,2)) 
     warn(['Size disagreement in the variable par in function prodgamsim']); fl=[]; return
end     

if nargin==2    
     M=varargin{1};
    if and(size(par.a,1)~=M,size(par.a,1)~=1) warn(['Size disagreement in the variable par in function prodgamsim']); fl=[]; return;     end 
else 
    M=size(par.a,1); 
end
    

if size(par.a,1)==1  %  a sequence of M draws from a single density  
    
  simout = max(gamrnd(repmat(par.a,M,1),1),1e-10)./repmat(par.b,M,1);     

   
else  % a single draw from a sequence of densities
    
  simout = max(gamrnd(par.a,1),1e-10)./[par.b];     
    
 end

