%	 Copyright (C) 2008  Frhwirth-Schnatter
%	 Copyright (C) 2011  Bluder, Plankensteiner
%
%    This program is free software: you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation, either version 3 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program.  If not, see <http://www.gnu.org/licenses/>.

function data=simulate_MOE(mix,N,varargin)

% Simulate from of a model  stored in the structure array mix
% Store the result in the structure array data

% modified such that only mixtures of normal distributions can be simulated
  
rand('state',sum(100*clock)) ;
randn('state',sum(100*clock)) ;

mixdef=mix;
if ~isfield(mix,'K')   % single member from the distribution family
    mix.K=1;
end
 
%% simulate the allocations
if  mix.K==1
    
    mix.weight=1;
    S=ones(1,N);
    
else
    if ~isfield(mix,'indicmod') mix.indicmod.dist='Multinomial';  end

    if   mix.indicmod.dist(1:6)=='Multin'

        %Simulate the allocations S for a finite mixture model

    rnd = rand(N,1);
    fv=mix.weight(ones(N,1),:);
    S = (sum(cumsum(fv,2) < rnd(:,ones(mix.K,1)),2) + 1)';
        % modification by Plankensteiner begin
    elseif   warn(['Function not implemented for ' mix.indicmod.dist]); return;
        % modification end
    end

end


%% simulate from finite mixtures of multiple regression models and MSAR models

    if isfield(mix,'d')
        simulatedesign=false;
        if nargin==3
            if ~isfield(varargin{1},'X')
                if mix.d==1
                    data.X=ones(1,N);
                else
                   % warn('No design matrix is available to simulate from a mixture regression model; design is simulated');
                    simulatedesign=true;
                end
            else
                data.X=varargin{1}.X;
            end
        else
            if mix.d>1   simulatedesign=true;  else  data.X=ones(1,N);  end
       end

       if  simulatedesign
            % no design
           if all(mix.dist(1:6)=='Normal')
                a=0;b=1; 
           else
              warn(['Function is only implemented to simulate from a normal distribution.']); return;
           end
           data.X=[a+b*rand(mix.d-1,N); ones(1,N)];
        end
    else
        data.X=ones(1,N); mix.d=1;
    end



   if isfield(mix,'indexdf')
       mix.df=size(mix.indexdf,1)*size(mix.indexdf,2);
            % intercept=[1:mix.d];
            % indexdr=intercept(all(repmat(mix.indexdf,1,mix.d)~=repmat([1:mix.d],mix.df,1),1));
       indexdr= all(repmat(mix.indexdf,1,mix.d)~=repmat([1:mix.d],mix.df,1),1);
       mu=mix.par.beta'*data.X(indexdr,:);
       mu=mu+repmat(mix.par.alpha'*data.X(mix.indexdf,:),mix.K,1);
  else
       mu=mix.par.beta'*data.X;
  end

     
  y=sum(mu.*(repmat(S,mix.K,1)==(repmat([1:mix.K]',1,N))),1)+sqrt(mix.par.sigma(S)).*randn(1,N);
        



   data.type{1}='continuous';
   r=1;


%% define the output structural array

data.y=y;
data.S=S;
data.N=N;
data.r=r;
data.sim=true;
data.model=mixdef;

if isfield(data,'ystart') data=rmfield(data,'ystart'); end